/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.config.DefaultFlowRegistry;
import org.springframework.webflow.config.FlowBuilderServicesBuilder;
import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.config.FlowDefinitionResourceFactory;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.DefaultFlowHolder;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderContextImpl;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.xml.XmlFlowModelBuilder;

public class FlowDefinitionRegistryBuilder {
    private final List<FlowLocation> flowLocations = new ArrayList<FlowLocation>();
    private final List<String> flowLocationPatterns = new ArrayList<String>();
    private final List<FlowBuilderInfo> flowBuilderInfos = new ArrayList<FlowBuilderInfo>();
    private FlowBuilderServices flowBuilderServices;
    private FlowDefinitionRegistry parent;
    private FlowDefinitionResourceFactory flowResourceFactory;

    public FlowDefinitionRegistryBuilder(ApplicationContext appContext) {
        this(appContext, null);
    }

    public FlowDefinitionRegistryBuilder(ApplicationContext appContext, FlowBuilderServices builderServices) {
        Assert.notNull((Object)appContext, (String)"applicationContext is required");
        this.flowResourceFactory = new FlowDefinitionResourceFactory((ResourceLoader)appContext);
        if (builderServices != null) {
            this.flowBuilderServices = builderServices;
        } else {
            this.flowBuilderServices = new FlowBuilderServicesBuilder().build();
            this.flowBuilderServices.setApplicationContext(appContext);
        }
    }

    public FlowDefinitionRegistryBuilder setBasePath(String basePath) {
        if (basePath != null) {
            this.flowResourceFactory.setBasePath(basePath);
        }
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowLocation(String path) {
        this.addFlowLocation(path, null, null);
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowLocation(String path, String id) {
        this.flowLocations.add(new FlowLocation(path, id, null));
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowLocation(String path, String id, Map<String, Object> attributes) {
        this.flowLocations.add(new FlowLocation(path, id, attributes));
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowLocationPattern(String pattern) {
        this.flowLocationPatterns.add(pattern);
        return this;
    }

    public FlowDefinitionRegistryBuilder setFlowBuilderServices(FlowBuilderServices flowBuilderServices) {
        this.flowBuilderServices = flowBuilderServices;
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowBuilder(FlowBuilder builder) {
        this.addFlowBuilder(builder, null, null);
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowBuilder(FlowBuilder builder, String id) {
        this.addFlowBuilder(builder, id, null);
        return this;
    }

    public FlowDefinitionRegistryBuilder addFlowBuilder(FlowBuilder builder, String id, Map<String, Object> attributes) {
        if (!StringUtils.hasText((String)id)) {
            id = StringUtils.uncapitalize((String)StringUtils.delete((String)ClassUtils.getShortName(builder.getClass()), (String)"FlowBuilder"));
        }
        this.flowBuilderInfos.add(new FlowBuilderInfo(builder, id, attributes));
        return this;
    }

    public FlowDefinitionRegistryBuilder setParent(FlowDefinitionRegistry parent) {
        this.parent = parent;
        return this;
    }

    public FlowDefinitionRegistry build() {
        DefaultFlowRegistry flowRegistry = new DefaultFlowRegistry();
        flowRegistry.setParent(this.parent);
        this.registerFlowLocations(flowRegistry);
        this.registerFlowLocationPatterns(flowRegistry);
        this.registerFlowBuilders(flowRegistry);
        return flowRegistry;
    }

    private void registerFlowLocations(DefaultFlowRegistry flowRegistry) {
        for (FlowLocation location : this.flowLocations) {
            String path = location.getPath();
            String id = location.getId();
            AttributeMap<Object> attributes = location.getAttributes();
            this.updateFlowAttributes(attributes);
            FlowDefinitionResource resource = this.flowResourceFactory.createResource(path, attributes, id);
            this.registerFlow(resource, flowRegistry);
        }
    }

    private void registerFlowLocationPatterns(DefaultFlowRegistry flowRegistry) {
        for (String pattern : this.flowLocationPatterns) {
            FlowDefinitionResource[] resources;
            LocalAttributeMap<Object> attributes = new LocalAttributeMap<Object>();
            this.updateFlowAttributes(attributes);
            try {
                resources = this.flowResourceFactory.createResources(pattern, attributes);
            }
            catch (IOException e) {
                IllegalStateException ise = new IllegalStateException("An I/O Exception occurred resolving the flow location pattern '" + pattern + "'");
                ise.initCause(e);
                throw ise;
            }
            for (FlowDefinitionResource resource : resources) {
                this.registerFlow(resource, flowRegistry);
            }
        }
    }

    private void registerFlow(FlowDefinitionResource resource, DefaultFlowRegistry flowRegistry) {
        if (!resource.getPath().getFilename().endsWith(".xml")) {
            throw new IllegalArgumentException(String.valueOf(resource) + " is not a supported resource type; supported types are [.xml]");
        }
        XmlFlowModelBuilder flowModelBuilder = new XmlFlowModelBuilder(resource.getPath(), flowRegistry.getFlowModelRegistry());
        DefaultFlowModelHolder flowModelHolder = new DefaultFlowModelHolder(flowModelBuilder);
        FlowModelFlowBuilder flowBuilder = new FlowModelFlowBuilder(flowModelHolder);
        FlowBuilderContextImpl builderContext = new FlowBuilderContextImpl(resource.getId(), resource.getAttributes(), flowRegistry, this.flowBuilderServices);
        FlowAssembler assembler = new FlowAssembler(flowBuilder, builderContext);
        DefaultFlowHolder flowHolder = new DefaultFlowHolder(assembler);
        flowRegistry.getFlowModelRegistry().registerFlowModel(resource.getId(), flowModelHolder);
        flowRegistry.registerFlowDefinition(flowHolder);
    }

    private void registerFlowBuilders(DefaultFlowRegistry flowRegistry) {
        for (FlowBuilderInfo info : this.flowBuilderInfos) {
            AttributeMap<Object> attributes = info.getAttributes();
            this.updateFlowAttributes(attributes);
            FlowBuilderContextImpl builderContext = new FlowBuilderContextImpl(info.getId(), attributes, flowRegistry, this.flowBuilderServices);
            FlowAssembler assembler = new FlowAssembler(info.getBuilder(), builderContext);
            flowRegistry.registerFlowDefinition(assembler.assembleFlow());
        }
    }

    private void updateFlowAttributes(AttributeMap<Object> attributes) {
        if (this.flowBuilderServices.getDevelopment()) {
            attributes.asMap().put("development", true);
        }
    }

    private static class FlowLocation {
        private final String path;
        private final String id;
        private final AttributeMap<Object> attributes;

        public FlowLocation(String path, String id, Map<String, Object> attributes) {
            this.path = path;
            this.id = id;
            this.attributes = attributes != null ? new LocalAttributeMap<Object>(attributes) : new LocalAttributeMap(new HashMap());
        }

        public String getPath() {
            return this.path;
        }

        public String getId() {
            return this.id;
        }

        public AttributeMap<Object> getAttributes() {
            return this.attributes;
        }
    }

    private static class FlowBuilderInfo {
        private final FlowBuilder builder;
        private final String id;
        private final AttributeMap<Object> attributes;

        public FlowBuilderInfo(FlowBuilder builder, String id, Map<String, Object> attributes) {
            this.builder = builder;
            this.id = id;
            this.attributes = attributes != null ? new LocalAttributeMap<Object>(attributes) : new LocalAttributeMap(new HashMap());
        }

        public FlowBuilder getBuilder() {
            return this.builder;
        }

        public String getId() {
            return this.id;
        }

        public AttributeMap<Object> getAttributes() {
            return this.attributes;
        }
    }
}

