/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.ActionStateModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.BeanImportModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.BindingModel;
import org.springframework.webflow.engine.model.DecisionStateModel;
import org.springframework.webflow.engine.model.EndStateModel;
import org.springframework.webflow.engine.model.EvaluateModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.IfModel;
import org.springframework.webflow.engine.model.InputModel;
import org.springframework.webflow.engine.model.OutputModel;
import org.springframework.webflow.engine.model.PersistenceContextModel;
import org.springframework.webflow.engine.model.RenderModel;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.SetModel;
import org.springframework.webflow.engine.model.SubflowStateModel;
import org.springframework.webflow.engine.model.TransitionModel;
import org.springframework.webflow.engine.model.VarModel;
import org.springframework.webflow.engine.model.ViewStateModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.builder.xml.DefaultDocumentLoader;
import org.springframework.webflow.engine.model.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.model.registry.FlowModelLocator;
import org.springframework.webflow.engine.model.registry.NoSuchFlowModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlFlowModelBuilder
implements FlowModelBuilder {
    private Resource resource;
    private FlowModelLocator modelLocator;
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private Document document;
    private long lastModifiedTimestamp;
    private FlowModel flowModel;

    public XmlFlowModelBuilder(Resource resource) {
        this.init(resource, null);
    }

    public XmlFlowModelBuilder(Resource resource, FlowModelLocator modelLocator) {
        this.init(resource, modelLocator);
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        Assert.notNull((Object)documentLoader, (String)"The XML document loader is required");
        this.documentLoader = documentLoader;
    }

    public void init() throws FlowModelBuilderException {
        try {
            this.document = this.documentLoader.loadDocument(this.resource);
            this.initLastModifiedTimestamp();
        }
        catch (IOException e) {
            throw new FlowModelBuilderException("Could not access the XML flow definition at " + this.resource, e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowModelBuilderException("Could not configure the parser to parse the XML flow definition at " + this.resource, e);
        }
        catch (SAXException e) {
            throw new FlowModelBuilderException("Could not parse the XML flow definition document at " + this.resource, e);
        }
    }

    public void build() throws FlowModelBuilderException {
        if (this.getDocumentElement() == null) {
            throw new FlowModelBuilderException("The FlowModelBuilder must be initialized first -- called init() before calling build()");
        }
        this.flowModel = this.parseFlow(this.getDocumentElement());
        this.mergeFlows();
        this.mergeStates();
    }

    public FlowModel getFlowModel() throws FlowModelBuilderException {
        if (this.flowModel == null) {
            throw new FlowModelBuilderException("The FlowModel must be built first -- called init() and build() before calling getFlowModel()");
        }
        return this.flowModel;
    }

    public void dispose() throws FlowModelBuilderException {
        this.document = null;
        this.flowModel = null;
    }

    public Resource getFlowModelResource() {
        return this.resource;
    }

    public boolean hasFlowModelResourceChanged() {
        if (this.lastModifiedTimestamp == -1L) {
            return false;
        }
        try {
            long lastModified = this.resource.lastModified();
            return lastModified > this.lastModifiedTimestamp;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document != null ? this.document.getDocumentElement() : null;
    }

    private void init(Resource resource, FlowModelLocator modelLocator) {
        Assert.notNull((Object)resource, (String)"The location of the XML-based flow definition is required");
        this.resource = resource;
        this.modelLocator = modelLocator;
    }

    private void initLastModifiedTimestamp() {
        try {
            this.lastModifiedTimestamp = this.resource.lastModified();
        }
        catch (IOException e) {
            this.lastModifiedTimestamp = -1L;
        }
    }

    private FlowModel parseFlow(Element element) {
        FlowModel flow = new FlowModel();
        flow.setAbstract(element.getAttribute("abstract"));
        flow.setParent(element.getAttribute("parent"));
        flow.setStartStateId(element.getAttribute("start-state"));
        flow.setAttributes(this.parseAttributes(element));
        flow.setSecured(this.parseSecured(element));
        flow.setPersistenceContext(this.parsePersistenceContext(element));
        flow.setVars(this.parseVars(element));
        flow.setInputs(this.parseInputs(element));
        flow.setOnStartActions(this.parseOnStartActions(element));
        flow.setStates(this.parseStates(element));
        flow.setGlobalTransitions(this.parseGlobalTransitions(element));
        flow.setOnEndActions(this.parseOnEndActions(element));
        flow.setOutputs(this.parseOutputs(element));
        flow.setExceptionHandlers(this.parseExceptionHandlers(element));
        flow.setBeanImports(this.parseBeanImports(element));
        return flow;
    }

    private LinkedList parseAttributes(Element element) {
        List attributeElements = DomUtils.getChildElementsByTagName((Element)element, (String)"attribute");
        if (attributeElements.isEmpty()) {
            return null;
        }
        LinkedList<AttributeModel> attributes = new LinkedList<AttributeModel>();
        Iterator it = attributeElements.iterator();
        while (it.hasNext()) {
            attributes.add(this.parseAttribute((Element)it.next()));
        }
        return attributes;
    }

    private LinkedList parseVars(Element element) {
        List varElements = DomUtils.getChildElementsByTagName((Element)element, (String)"var");
        if (varElements.isEmpty()) {
            return null;
        }
        LinkedList<VarModel> vars = new LinkedList<VarModel>();
        Iterator it = varElements.iterator();
        while (it.hasNext()) {
            vars.add(this.parseVar((Element)it.next()));
        }
        return vars;
    }

    private LinkedList parseInputs(Element element) {
        List inputElements = DomUtils.getChildElementsByTagName((Element)element, (String)"input");
        if (inputElements.isEmpty()) {
            return null;
        }
        LinkedList<InputModel> inputs = new LinkedList<InputModel>();
        Iterator it = inputElements.iterator();
        while (it.hasNext()) {
            inputs.add(this.parseInput((Element)it.next()));
        }
        return inputs;
    }

    private LinkedList parseOutputs(Element element) {
        List outputElements = DomUtils.getChildElementsByTagName((Element)element, (String)"output");
        if (outputElements.isEmpty()) {
            return null;
        }
        LinkedList<OutputModel> outputs = new LinkedList<OutputModel>();
        Iterator it = outputElements.iterator();
        while (it.hasNext()) {
            outputs.add(this.parseOutput((Element)it.next()));
        }
        return outputs;
    }

    private LinkedList parseActions(Element element) {
        List actionElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"evaluate", "render", "set"});
        if (actionElements.isEmpty()) {
            return null;
        }
        LinkedList<AbstractActionModel> actions = new LinkedList<AbstractActionModel>();
        Iterator it = actionElements.iterator();
        while (it.hasNext()) {
            actions.add(this.parseAction((Element)it.next()));
        }
        return actions;
    }

    private LinkedList parseStates(Element element) {
        List stateElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"view-state", "action-state", "decision-state", "subflow-state", "end-state"});
        if (stateElements.isEmpty()) {
            return null;
        }
        LinkedList<AbstractStateModel> states = new LinkedList<AbstractStateModel>();
        Iterator it = stateElements.iterator();
        while (it.hasNext()) {
            states.add(this.parseState((Element)it.next()));
        }
        return states;
    }

    private LinkedList parseTransitions(Element element) {
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)"transition");
        if (transitionElements.isEmpty()) {
            return null;
        }
        LinkedList<TransitionModel> transitions = new LinkedList<TransitionModel>();
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            transitions.add(this.parseTransition((Element)it.next()));
        }
        return transitions;
    }

    private LinkedList parseExceptionHandlers(Element element) {
        List exceptionHandlerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"exception-handler");
        if (exceptionHandlerElements.isEmpty()) {
            return null;
        }
        LinkedList<ExceptionHandlerModel> exceptionHandlers = new LinkedList<ExceptionHandlerModel>();
        Iterator it = exceptionHandlerElements.iterator();
        while (it.hasNext()) {
            exceptionHandlers.add(this.parseExceptionHandler((Element)it.next()));
        }
        return exceptionHandlers;
    }

    private LinkedList parseBeanImports(Element element) {
        List importElements = DomUtils.getChildElementsByTagName((Element)element, (String)"bean-import");
        if (importElements.isEmpty()) {
            return null;
        }
        LinkedList<BeanImportModel> beanImports = new LinkedList<BeanImportModel>();
        Iterator it = importElements.iterator();
        while (it.hasNext()) {
            beanImports.add(this.parseBeanImport((Element)it.next()));
        }
        return beanImports;
    }

    private LinkedList parseIfs(Element element) {
        List ifElements = DomUtils.getChildElementsByTagName((Element)element, (String)"if");
        if (ifElements.isEmpty()) {
            return null;
        }
        LinkedList<IfModel> ifs = new LinkedList<IfModel>();
        Iterator it = ifElements.iterator();
        while (it.hasNext()) {
            ifs.add(this.parseIf((Element)it.next()));
        }
        return ifs;
    }

    private AbstractActionModel parseAction(Element element) {
        if (DomUtils.nodeNameEquals((Node)element, (String)"evaluate")) {
            return this.parseEvaluate(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"render")) {
            return this.parseRender(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"set")) {
            return this.parseSet(element);
        }
        throw new FlowModelBuilderException("Unknown action element encountered '" + element.getLocalName() + "'");
    }

    private AbstractStateModel parseState(Element element) {
        if (DomUtils.nodeNameEquals((Node)element, (String)"view-state")) {
            return this.parseViewState(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"action-state")) {
            return this.parseActionState(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"decision-state")) {
            return this.parseDecisionState(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"subflow-state")) {
            return this.parseSubflowState(element);
        }
        if (DomUtils.nodeNameEquals((Node)element, (String)"end-state")) {
            return this.parseEndState(element);
        }
        throw new FlowModelBuilderException("Unknown state element encountered '" + element.getLocalName() + "'");
    }

    private LinkedList parseGlobalTransitions(Element element) {
        if ((element = DomUtils.getChildElementByTagName((Element)element, (String)"global-transitions")) == null) {
            return null;
        }
        return this.parseTransitions(element);
    }

    private AttributeModel parseAttribute(Element element) {
        AttributeModel attribute = new AttributeModel(element.getAttribute("name"), this.parseAttributeValue(element));
        attribute.setType(element.getAttribute("type"));
        return attribute;
    }

    private String parseAttributeValue(Element element) {
        if (element.hasAttribute("value")) {
            return element.getAttribute("value");
        }
        Element valueElement = DomUtils.getChildElementByTagName((Element)element, (String)"value");
        if (valueElement != null) {
            return DomUtils.getTextValue((Element)valueElement);
        }
        return null;
    }

    private SecuredModel parseSecured(Element element) {
        if ((element = DomUtils.getChildElementByTagName((Element)element, (String)"secured")) == null) {
            return null;
        }
        SecuredModel secured = new SecuredModel(element.getAttribute("attributes"));
        secured.setMatch(element.getAttribute("match"));
        return secured;
    }

    private PersistenceContextModel parsePersistenceContext(Element element) {
        if ((element = DomUtils.getChildElementByTagName((Element)element, (String)"persistence-context")) == null) {
            return null;
        }
        return new PersistenceContextModel();
    }

    private VarModel parseVar(Element element) {
        return new VarModel(element.getAttribute("name"), element.getAttribute("class"));
    }

    private InputModel parseInput(Element element) {
        InputModel input = new InputModel(element.getAttribute("name"), element.getAttribute("value"));
        input.setType(element.getAttribute("type"));
        input.setRequired(element.getAttribute("required"));
        return input;
    }

    private OutputModel parseOutput(Element element) {
        OutputModel output = new OutputModel(element.getAttribute("name"), element.getAttribute("value"));
        output.setType(element.getAttribute("type"));
        output.setRequired(element.getAttribute("required"));
        return output;
    }

    private TransitionModel parseTransition(Element element) {
        TransitionModel transition = new TransitionModel();
        transition.setOn(element.getAttribute("on"));
        transition.setTo(element.getAttribute("to"));
        transition.setOnException(element.getAttribute("on-exception"));
        transition.setBind(element.getAttribute("bind"));
        transition.setValidate(element.getAttribute("validate"));
        transition.setHistory(element.getAttribute("history"));
        transition.setAttributes(this.parseAttributes(element));
        transition.setSecured(this.parseSecured(element));
        transition.setActions(this.parseActions(element));
        return transition;
    }

    private ExceptionHandlerModel parseExceptionHandler(Element element) {
        return new ExceptionHandlerModel(element.getAttribute("bean"));
    }

    private BeanImportModel parseBeanImport(Element element) {
        return new BeanImportModel(element.getAttribute("resource"));
    }

    private IfModel parseIf(Element element) {
        IfModel ifModel = new IfModel(element.getAttribute("test"), element.getAttribute("then"));
        ifModel.setElse(element.getAttribute("else"));
        return ifModel;
    }

    private LinkedList parseOnStartActions(Element element) {
        Element onStartElement = DomUtils.getChildElementByTagName((Element)element, (String)"on-start");
        if (onStartElement != null) {
            return this.parseActions(onStartElement);
        }
        return null;
    }

    private LinkedList parseOnEntryActions(Element element) {
        Element onEntryElement = DomUtils.getChildElementByTagName((Element)element, (String)"on-entry");
        if (onEntryElement != null) {
            return this.parseActions(onEntryElement);
        }
        return null;
    }

    private LinkedList parseOnRenderActions(Element element) {
        Element onRenderElement = DomUtils.getChildElementByTagName((Element)element, (String)"on-render");
        if (onRenderElement != null) {
            return this.parseActions(onRenderElement);
        }
        return null;
    }

    private BinderModel parseBinder(Element element) {
        Element binderElement = DomUtils.getChildElementByTagName((Element)element, (String)"binder");
        if (binderElement != null) {
            BinderModel binder = new BinderModel();
            binder.setBindings(this.parseBindings(binderElement));
            return binder;
        }
        return null;
    }

    private LinkedList parseBindings(Element element) {
        List bindingElements = DomUtils.getChildElementsByTagName((Element)element, (String)"binding");
        if (bindingElements.isEmpty()) {
            return null;
        }
        LinkedList<BindingModel> bindings = new LinkedList<BindingModel>();
        Iterator it = bindingElements.iterator();
        while (it.hasNext()) {
            bindings.add(this.parseBinding((Element)it.next()));
        }
        return bindings;
    }

    private BindingModel parseBinding(Element element) {
        return new BindingModel(element.getAttribute("property"), element.getAttribute("converter"), element.getAttribute("required"));
    }

    private LinkedList parseOnExitActions(Element element) {
        Element onExitElement = DomUtils.getChildElementByTagName((Element)element, (String)"on-exit");
        if (onExitElement != null) {
            return this.parseActions(onExitElement);
        }
        return null;
    }

    private LinkedList parseOnEndActions(Element element) {
        Element onEndElement = DomUtils.getChildElementByTagName((Element)element, (String)"on-end");
        if (onEndElement != null) {
            return this.parseActions(onEndElement);
        }
        return null;
    }

    private EvaluateModel parseEvaluate(Element element) {
        EvaluateModel evaluate = new EvaluateModel(element.getAttribute("expression"));
        evaluate.setResult(element.getAttribute("result"));
        evaluate.setResultType(element.getAttribute("result-type"));
        evaluate.setAttributes(this.parseAttributes(element));
        return evaluate;
    }

    private RenderModel parseRender(Element element) {
        RenderModel render = new RenderModel(element.getAttribute("fragments"));
        render.setAttributes(this.parseAttributes(element));
        return render;
    }

    private SetModel parseSet(Element element) {
        SetModel set = new SetModel(element.getAttribute("name"), element.getAttribute("value"));
        set.setType(element.getAttribute("type"));
        set.setAttributes(this.parseAttributes(element));
        return set;
    }

    private ActionStateModel parseActionState(Element element) {
        ActionStateModel state = new ActionStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        state.setActions(this.parseActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private ViewStateModel parseViewState(Element element) {
        ViewStateModel state = new ViewStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setView(element.getAttribute("view"));
        state.setRedirect(element.getAttribute("redirect"));
        state.setPopup(element.getAttribute("popup"));
        state.setModel(element.getAttribute("model"));
        state.setVars(this.parseVars(element));
        state.setBinder(this.parseBinder(element));
        state.setOnRenderActions(this.parseOnRenderActions(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        return state;
    }

    private DecisionStateModel parseDecisionState(Element element) {
        DecisionStateModel state = new DecisionStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setIfs(this.parseIfs(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private SubflowStateModel parseSubflowState(Element element) {
        SubflowStateModel state = new SubflowStateModel(element.getAttribute("id"), element.getAttribute("subflow"));
        state.setParent(element.getAttribute("parent"));
        state.setSubflowAttributeMapper(element.getAttribute("subflow-attribute-mapper"));
        state.setInputs(this.parseInputs(element));
        state.setOutputs(this.parseOutputs(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        return state;
    }

    private EndStateModel parseEndState(Element element) {
        EndStateModel state = new EndStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setView(element.getAttribute("view"));
        state.setCommit(element.getAttribute("commit"));
        state.setOutputs(this.parseOutputs(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private void mergeFlows() {
        if (this.flowModel.getParent() != null) {
            List<String> parents = Arrays.asList(StringUtils.trimArrayElements((String[])this.flowModel.getParent().split(",")));
            for (String parentFlowId : parents) {
                if (!StringUtils.hasText((String)parentFlowId)) continue;
                try {
                    this.flowModel.merge(this.modelLocator.getFlowModel(parentFlowId));
                }
                catch (NoSuchFlowModelException e) {
                    throw new FlowModelBuilderException("Unable to find flow '" + parentFlowId + "' to inherit from", e);
                }
            }
        }
    }

    private void mergeStates() {
        if (this.flowModel.getStates() == null) {
            return;
        }
        for (AbstractStateModel childState : this.flowModel.getStates()) {
            String parent = childState.getParent();
            if (childState.getParent() == null) continue;
            AbstractStateModel parentState = null;
            int hashIndex = parent.indexOf("#");
            if (hashIndex == -1) {
                throw new FlowModelBuilderException("Invalid parent syntax '" + parent + "', should take form 'flowId#stateId'");
            }
            String flowId = parent.substring(0, hashIndex).trim();
            String stateId = parent.substring(hashIndex + 1).trim();
            try {
                parentState = StringUtils.hasText((String)flowId) ? this.modelLocator.getFlowModel(flowId).getStateById(stateId) : this.flowModel.getStateById(stateId);
                if (parentState == null) {
                    throw new FlowModelBuilderException("Unable to find state '" + stateId + "' in flow '" + flowId + "'");
                }
                childState.merge(parentState);
            }
            catch (NoSuchFlowModelException e) {
                throw new FlowModelBuilderException("Unable to find flow '" + flowId + "' to inherit from", e);
            }
            catch (ClassCastException e) {
                throw new FlowModelBuilderException("Parent state type '" + parentState.getClass().getName() + "' cannot be merged with state type '" + childState.getClass().getName() + "'", e);
            }
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("resource", (Object)this.resource).toString();
    }
}

