/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;

public class FlowExecutorImpl
implements FlowExecutor {
    private static final Log logger = LogFactory.getLog(FlowExecutorImpl.class);
    private FlowDefinitionLocator definitionLocator;
    private FlowExecutionFactory executionFactory;
    private FlowExecutionRepository executionRepository;

    public FlowExecutorImpl(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        Assert.notNull((Object)definitionLocator, (String)"The locator for accessing flow definitions is required");
        Assert.notNull((Object)executionFactory, (String)"The execution factory for creating new flow executions is required");
        Assert.notNull((Object)executionRepository, (String)"The repository for persisting flow executions is required");
        this.definitionLocator = definitionLocator;
        this.executionFactory = executionFactory;
        this.executionRepository = executionRepository;
    }

    public FlowDefinitionLocator getDefinitionLocator() {
        return this.definitionLocator;
    }

    public FlowExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    public FlowExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    public FlowExecutionResult launchExecution(String flowId, MutableAttributeMap input, ExternalContext context) throws FlowException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Launching new execution of flow '" + flowId + "' with input " + input));
            }
            ExternalContextHolder.setExternalContext(context);
            FlowDefinition flowDefinition = this.definitionLocator.getFlowDefinition(flowId);
            FlowExecution flowExecution = this.executionFactory.createFlowExecution(flowDefinition);
            flowExecution.start(input, context);
            if (!flowExecution.hasEnded()) {
                FlowExecutionLock lock = this.executionRepository.getLock(flowExecution.getKey());
                lock.lock();
                try {
                    this.executionRepository.putFlowExecution(flowExecution);
                }
                finally {
                    lock.unlock();
                }
                FlowExecutionResult flowExecutionResult = this.createPausedResult(flowExecution);
                return flowExecutionResult;
            }
            FlowExecutionResult flowExecutionResult = this.createEndResult(flowExecution);
            return flowExecutionResult;
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    public FlowExecutionResult resumeExecution(String flowExecutionKey, ExternalContext context) throws FlowException {
        try {
            FlowExecution flowExecution;
            FlowExecutionLock lock;
            block9: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resuming flow execution with key '" + flowExecutionKey));
                }
                ExternalContextHolder.setExternalContext(context);
                FlowExecutionKey key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
                lock = this.executionRepository.getLock(key);
                lock.lock();
                try {
                    flowExecution = this.executionRepository.getFlowExecution(key);
                    flowExecution.resume(context);
                    if (flowExecution.hasEnded()) break block9;
                    this.executionRepository.putFlowExecution(flowExecution);
                    FlowExecutionResult flowExecutionResult = this.createPausedResult(flowExecution);
                    lock.unlock();
                    return flowExecutionResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            this.executionRepository.removeFlowExecution(flowExecution);
            FlowExecutionResult flowExecutionResult = this.createEndResult(flowExecution);
            lock.unlock();
            return flowExecutionResult;
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    private FlowExecutionResult createEndResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createEndedResult(flowExecution.getDefinition().getId(), flowExecution.getOutcome());
    }

    private FlowExecutionResult createPausedResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createPausedResult(flowExecution.getDefinition().getId(), flowExecution.getKey().toString());
    }
}

