/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import java.util.HashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.faces.config.FlowBuilderServicesBuilder;
import org.springframework.faces.webflow.JsfResourceRequestHandler;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.config.FlowExecutorBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

public class AbstractFacesFlowConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected FlowExecutorBuilder getFlowExecutorBuilder(FlowDefinitionLocator flowRegistry) {
        return new FlowExecutorBuilder(flowRegistry);
    }

    protected FlowDefinitionRegistryBuilder getFlowDefinitionRegistryBuilder() {
        return new FlowDefinitionRegistryBuilder(this.applicationContext);
    }

    protected FlowDefinitionRegistryBuilder getFlowDefinitionRegistryBuilder(FlowBuilderServices flowBuilderServices) {
        return new FlowDefinitionRegistryBuilder(this.applicationContext, flowBuilderServices);
    }

    protected FlowBuilderServicesBuilder getFlowBuilderServicesBuilder() {
        return new FlowBuilderServicesBuilder();
    }

    @Bean
    public SimpleUrlHandlerMapping jsrResourceHandlerMapping() {
        HashMap<String, JsfResourceRequestHandler> urlMap = new HashMap<String, JsfResourceRequestHandler>();
        urlMap.put("/jakarta.faces.resource/**", this.jsfResourceRequestHandler());
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setUrlMap(urlMap);
        handlerMapping.setOrder(0);
        return handlerMapping;
    }

    @Bean
    public JsfResourceRequestHandler jsfResourceRequestHandler() {
        return new JsfResourceRequestHandler();
    }

    @Bean
    public HttpRequestHandlerAdapter httpRequestHandlerAdapter() {
        return new HttpRequestHandlerAdapter();
    }
}

