/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import com.sun.faces.component.CompositeComponentStackManager;
import java.util.EnumSet;
import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.JsfView;
import org.springframework.faces.webflow.PostRestoreStateEventVisitCallback;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class JsfViewFactory
implements ViewFactory {
    private static final Log logger = LogFactory.getLog(JsfViewFactory.class);
    private final Expression viewIdExpression;
    private final Lifecycle lifecycle;

    public JsfViewFactory(Expression viewIdExpression, Lifecycle lifecycle) {
        this.viewIdExpression = viewIdExpression;
        this.lifecycle = lifecycle;
    }

    public View getView(RequestContext context) {
        boolean notifyPhaseListeners;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("FacesContext has not been initialized within the current Web Flow request. Has FlowFacesContextLifecycleListener been added?");
        }
        facesContext.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
        boolean bl = notifyPhaseListeners = !facesContext.getRenderResponse();
        if (notifyPhaseListeners) {
            JsfUtils.notifyBeforeListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        UIViewRoot viewRoot = this.getViewRoot(context, facesContext);
        facesContext.setViewRoot(viewRoot);
        this.publishPostRestoreStateEvent(facesContext);
        if (notifyPhaseListeners) {
            JsfUtils.notifyAfterListeners(PhaseId.RESTORE_VIEW, this.lifecycle, facesContext);
        }
        return new JsfView(viewRoot, this.lifecycle, context);
    }

    private UIViewRoot getViewRoot(RequestContext context, FacesContext facesContext) {
        ViewHandler viewHandler = this.getViewHandler(facesContext);
        String viewName = (String)this.viewIdExpression.getValue((Object)context);
        if (this.viewAlreadySet(facesContext, viewName)) {
            return this.getViewRootForAlreadySetView(context, facesContext);
        }
        if (context.inViewState()) {
            return this.getViewStateViewRoot(context, facesContext, viewHandler, viewName);
        }
        return this.getTransientViewRoot(context, facesContext, viewHandler, viewName);
    }

    private ViewHandler getViewHandler(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        if (!JsfRuntimeInformation.isPortletRequest(facesContext)) {
            viewHandler.initView(facesContext);
        }
        return viewHandler;
    }

    private boolean viewAlreadySet(FacesContext facesContext, String viewName) {
        return facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId().equals(viewName);
    }

    private UIViewRoot getViewRootForAlreadySetView(RequestContext context, FacesContext facesContext) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing view root found with id '" + facesContext.getViewRoot().getId() + "'"));
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        viewRoot.setLocale(context.getExternalContext().getLocale());
        this.processTree(facesContext, (UIComponent)viewRoot);
        return viewRoot;
    }

    private UIViewRoot getViewStateViewRoot(RequestContext context, FacesContext facesContext, ViewHandler handler, String viewName) {
        UIViewRoot viewRoot = handler.restoreView(facesContext, viewName);
        if (viewRoot != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UIViewRoot restored for '" + viewName + "'"));
            }
            this.processTree(facesContext, (UIComponent)viewRoot);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating UIViewRoot from '" + viewName + "'"));
            }
            viewRoot = handler.createView(facesContext, viewName);
        }
        return viewRoot;
    }

    private UIViewRoot getTransientViewRoot(RequestContext context, FacesContext facesContext, ViewHandler viewHandler, String viewName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating transient UIViewRoot from '" + viewName + "'"));
        }
        UIViewRoot viewRoot = viewHandler.createView(facesContext, viewName);
        viewRoot.setTransient(true);
        return viewRoot;
    }

    private void processTree(FacesContext context, UIComponent component) {
        ValueExpression binding;
        MojarraProcessTreeHandler mojarraTreeHandler = null;
        if (!JsfRuntimeInformation.isMyFacesInUse()) {
            mojarraTreeHandler = new MojarraProcessTreeHandler().handleBefore(context, component);
        }
        if (!context.getRenderResponse() && component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setValid(true);
        }
        if ((binding = component.getValueExpression("binding")) != null) {
            binding.setValue(context.getELContext(), (Object)component);
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            this.processTree(context, (UIComponent)it.next());
        }
        if (mojarraTreeHandler != null) {
            mojarraTreeHandler.handleAfter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishPostRestoreStateEvent(FacesContext facesContext) {
        EnumSet<VisitHint> visitHints = null;
        try {
            visitHints = EnumSet.of(VisitHint.SKIP_ITERATION);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        String attributeName = "javax.faces.visit.SKIP_ITERATION";
        facesContext.getAttributes().put(attributeName, true);
        try {
            VisitContext visitContext = visitHints != null ? VisitContext.createVisitContext((FacesContext)facesContext, null, visitHints) : VisitContext.createVisitContext((FacesContext)facesContext);
            facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new PostRestoreStateEventVisitCallback());
        }
        catch (AbortProcessingException e) {
            PhaseId phaseId = facesContext.getCurrentPhaseId();
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(facesContext, (Throwable)e, null, phaseId);
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)eventContext);
        }
        finally {
            facesContext.getAttributes().remove(attributeName);
        }
    }

    private static class MojarraProcessTreeHandler {
        private CompositeComponentStackManager stackManager;
        private boolean pushed;

        private MojarraProcessTreeHandler() {
        }

        public MojarraProcessTreeHandler handleBefore(FacesContext context, UIComponent component) {
            this.stackManager = CompositeComponentStackManager.getManager((FacesContext)context);
            if (UIComponent.isCompositeComponent((UIComponent)component)) {
                this.pushed = this.stackManager.push(component, CompositeComponentStackManager.StackType.TreeCreation);
            }
            return this;
        }

        public void handleAfter() {
            if (this.pushed) {
                this.stackManager.pop(CompositeComponentStackManager.StackType.TreeCreation);
            }
        }
    }
}

