/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.Locale;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.ViewRootHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowViewHandler
extends ViewHandlerWrapper {
    private final ViewHandler wrapped;

    public FlowViewHandler(ViewHandler wrapped) {
        Assert.notNull((Object)wrapped, (String)"The wrapped ViewHandler instance must not be null!");
        this.wrapped = wrapped;
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (JsfUtils.isFlowRequest()) {
            return RequestContextHolder.getRequestContext().getFlowExecutionUrl();
        }
        return super.getActionURL(context, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        if (JsfUtils.isFlowRequest()) {
            return RequestContextHolder.getRequestContext().getExternalContext().getLocale();
        }
        return super.calculateLocale(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        String resourcePath = viewId;
        if (JsfUtils.isFlowRequest()) {
            resourcePath = this.resolveResourcePath(RequestContextHolder.getRequestContext(), viewId);
        }
        return super.createView(context, resourcePath);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        String resourcePath = viewId;
        if (JsfUtils.isFlowRequest()) {
            resourcePath = this.resolveResourcePath(RequestContextHolder.getRequestContext(), viewId);
            return this.restoreFlowView(context, resourcePath);
        }
        return super.restoreView(context, resourcePath);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        if (JsfUtils.isFlowRequest()) {
            return this.resolveResourcePath(RequestContextHolder.getRequestContext(), rawViewId);
        }
        return super.deriveViewId(context, rawViewId);
    }

    private String resolveResourcePath(RequestContext context, String viewId) {
        if (viewId.startsWith("/")) {
            return viewId;
        }
        ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
        if (flowContext == null) {
            throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
        }
        Resource viewResource = flowContext.getResource(viewId);
        if (!(viewResource instanceof ContextResource)) {
            throw new IllegalStateException("A ContextResource is required to get relative view paths within this context; the resource was " + viewResource);
        }
        String viewPath = ((ContextResource)viewResource).getPathWithinContext();
        if (!viewPath.startsWith("/")) {
            viewPath = "/" + viewPath;
        }
        return viewPath;
    }

    private UIViewRoot restoreFlowView(FacesContext facesContext, String resourcePath) {
        RequestContext context = RequestContextHolder.getRequestContext();
        ViewRootHolder holder = (ViewRootHolder)context.getFlashScope().get("viewUserEventState");
        if (holder != null && holder.getViewRoot() != null && holder.getViewRoot().getViewId().equals(resourcePath)) {
            return holder.getViewRoot();
        }
        return super.restoreView(facesContext, resourcePath);
    }
}

