/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;

public class FlowLifecycle
extends Lifecycle {
    private static final Log logger = LogFactory.getLog(FlowLifecycle.class);
    private final Lifecycle delegate;

    public static Lifecycle newInstance() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle defaultLifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        return new FlowLifecycle(defaultLifecycle);
    }

    FlowLifecycle(Lifecycle delegate) {
        this.delegate = delegate;
    }

    public void execute(FacesContext context) throws FacesException {
        logger.debug((Object)"Executing view post back lifecycle");
        int p = PhaseId.APPLY_REQUEST_VALUES.getOrdinal();
        while (p <= PhaseId.INVOKE_APPLICATION.getOrdinal()) {
            PhaseId phaseId = (PhaseId)PhaseId.VALUES.get(p);
            if (!this.skipPhase(context, phaseId)) {
                if (JsfRuntimeInformation.isAtLeastJsf20()) {
                    context.setCurrentPhaseId(phaseId);
                }
                this.invokePhase(context, phaseId);
            }
            ++p;
        }
    }

    public void render(FacesContext context) throws FacesException {
        this.delegate.render(context);
    }

    public void addPhaseListener(PhaseListener listener) {
        this.delegate.addPhaseListener(listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.delegate.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener listener) {
        this.delegate.removePhaseListener(listener);
    }

    private boolean skipPhase(FacesContext context, PhaseId phaseId) {
        if (context.getResponseComplete()) {
            return true;
        }
        return context.getRenderResponse();
    }

    private void invokePhase(FacesContext context, PhaseId phaseId) {
        JsfUtils.notifyBeforeListeners(phaseId, this, context);
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            logger.debug((Object)"Processing decodes");
            context.getViewRoot().processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            logger.debug((Object)"Processing validators");
            context.getViewRoot().processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            logger.debug((Object)"Processing model updates");
            context.getViewRoot().processUpdates(context);
        } else {
            logger.debug((Object)"Processing application");
            context.getViewRoot().processApplication(context);
        }
        JsfUtils.notifyAfterListeners(phaseId, this, context);
    }
}

