/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import org.springframework.faces.webflow.FlowApplication;
import org.springframework.faces.webflow.Jsf2FlowApplication;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.util.Assert;

public class FlowApplicationFactory
extends ApplicationFactory {
    private ApplicationFactory delegate;

    public FlowApplicationFactory(ApplicationFactory delegate) {
        Assert.notNull((Object)delegate, (String)"The delegate ApplicationFactory instance must not be null!");
        this.delegate = delegate;
    }

    public Application getApplication() {
        Application delegateApplication = this.delegate.getApplication();
        if (delegateApplication != null && !(delegateApplication instanceof FlowApplication)) {
            FlowApplication flowApplication = JsfRuntimeInformation.isAtLeastJsf20() ? new Jsf2FlowApplication(delegateApplication) : new FlowApplication(delegateApplication);
            this.setApplication(flowApplication);
        }
        return this.delegate.getApplication();
    }

    public void setApplication(Application application) {
        this.delegate.setApplication(application);
    }

    public ApplicationFactory getWrapped() {
        return this.delegate;
    }
}

