/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import org.springframework.binding.convert.converters.StringToObject;

public class StringToBoolean
extends StringToObject {
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private String trueString;
    private String falseString;

    public StringToBoolean() {
        super(Boolean.class);
    }

    public StringToBoolean(String trueString, String falseString) {
        super(Boolean.class);
        this.trueString = trueString;
        this.falseString = falseString;
    }

    @Override
    protected Object toObject(String string, Class<?> targetClass) {
        if (this.trueString != null && string.equals(this.trueString)) {
            return true;
        }
        if (this.falseString != null && string.equals(this.falseString)) {
            return false;
        }
        if (this.trueString == null && string.equals(VALUE_TRUE)) {
            return true;
        }
        if (this.falseString == null && string.equals(VALUE_FALSE)) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean value [" + string + "]");
    }

    @Override
    protected String toString(Object object) {
        Boolean value = (Boolean)object;
        if (Boolean.TRUE.equals(value)) {
            if (this.trueString != null) {
                return this.trueString;
            }
            return VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(value)) {
            if (this.falseString != null) {
                return this.falseString;
            }
            return VALUE_FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value [" + value + "]");
    }
}

