/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.binding.mapping.impl.DefaultMappingResults;
import org.springframework.binding.mapping.results.RequiredError;
import org.springframework.binding.mapping.results.SourceAccessError;
import org.springframework.binding.mapping.results.Success;
import org.springframework.binding.mapping.results.TargetAccessError;
import org.springframework.binding.mapping.results.TypeConversionError;

public class DefaultMappingContext {
    private static final Log logger = LogFactory.getLog(DefaultMapping.class);
    private Object source;
    private Object target;
    private Mapping currentMapping;
    private List<MappingResult> mappingResults;

    public DefaultMappingContext(Object source, Object target) {
        this.source = source;
        this.target = target;
        this.mappingResults = new ArrayList<MappingResult>();
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public Mapping getCurrentMapping() {
        return this.currentMapping;
    }

    public void setCurrentMapping(Mapping mapping) {
        if (this.currentMapping != null) {
            throw new IllegalStateException("The current mapping has not finished yet");
        }
        this.currentMapping = mapping;
    }

    public void setSuccessResult(Object originalValue, Object mappedValue) {
        this.add(new Success(this.currentMapping, mappedValue, originalValue));
    }

    public void setRequiredErrorResult(Object originalValue) {
        this.add(new RequiredError(this.currentMapping, originalValue));
    }

    public void setTypeConversionErrorResult(Object originalValue, Exception cause) {
        this.add(new TypeConversionError(this.currentMapping, originalValue, cause));
    }

    public void setSourceAccessError(EvaluationException error) {
        this.add(new SourceAccessError(this.currentMapping, error));
    }

    public void setTargetAccessError(Object originalValue, EvaluationException error) {
        this.add(new TargetAccessError(this.currentMapping, originalValue, error));
    }

    public MappingResults getMappingResults() {
        return new DefaultMappingResults(this.source, this.target, this.mappingResults);
    }

    private void add(MappingResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding mapping result " + String.valueOf(result)));
        }
        this.mappingResults.add(result);
        this.currentMapping = null;
    }
}

