/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.el.ELContextFactory;
import org.springframework.util.Assert;

public class ELExpression
implements Expression {
    private ELContextFactory elContextFactory;
    private ValueExpression valueExpression;

    public ELExpression(ELContextFactory factory, ValueExpression valueExpression) {
        Assert.notNull((Object)factory, (String)"The ELContextFactory is required to evaluate EL expressions");
        Assert.notNull((Object)valueExpression, (String)"The EL ValueExpression is required for evaluation");
        this.elContextFactory = factory;
        this.valueExpression = valueExpression;
    }

    @Override
    public Object getValue(Object context) throws EvaluationException {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            Object result = this.valueExpression.getValue(ctx);
            if (result == null && !ctx.isPropertyResolved()) {
                if (this.getExpressionString().equals("null")) {
                    return null;
                }
                throw new EvaluationException(context.getClass(), this.getExpressionString(), "The expression '" + this.getExpressionString() + "' did not resolve... is the base variable '" + this.getBaseVariable() + "' spelled correctly?");
            }
            return result;
        }
        catch (jakarta.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "]", e);
        }
    }

    @Override
    public void setValue(Object context, Object value) throws EvaluationException {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            this.valueExpression.setValue(ctx, value);
            if (!ctx.isPropertyResolved()) {
                throw new EvaluationException(context.getClass(), this.getExpressionString(), "The expression '" + this.getExpressionString() + "' did not resolve... is the base variable ''" + this.getBaseVariable() + "' spelled correctly?");
            }
        }
        catch (jakarta.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "] to [" + String.valueOf(value) + "]", e);
        }
    }

    @Override
    public Class<?> getValueType(Object context) {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            return this.valueExpression.getType(ctx);
        }
        catch (jakarta.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "]", e);
        }
    }

    @Override
    public String getExpressionString() {
        return this.valueExpression.getExpressionString();
    }

    private String getBaseVariable() {
        String expressionString = this.getExpressionString();
        int firstDot = expressionString.indexOf(46);
        if (firstDot == -1) {
            return expressionString;
        }
        return expressionString.substring(0, firstDot);
    }

    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ELExpression)) {
            return false;
        }
        ELExpression other = (ELExpression)o;
        return this.valueExpression.equals((Object)other.valueExpression);
    }

    public String toString() {
        return this.getExpressionString();
    }
}

