/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.beanwrapper;

import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;

public class BeanWrapperExpression
implements Expression {
    private String expression;
    private ConversionService conversionService;
    private boolean autoGrowNestedPaths = false;
    private int autoGrowCollectionLimit = Integer.MAX_VALUE;

    public BeanWrapperExpression(String expression, ConversionService conversionService) {
        this.expression = expression;
        this.conversionService = conversionService;
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BeanWrapperExpression)) {
            return false;
        }
        BeanWrapperExpression other = (BeanWrapperExpression)o;
        return this.expression.equals(other.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    @Override
    public Object getValue(Object context) throws EvaluationException {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            beanWrapper.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
            beanWrapper.setAutoGrowCollectionLimit(this.autoGrowCollectionLimit);
            return beanWrapper.getPropertyValue(this.expression);
        }
        catch (NotReadablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "A BeansException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "]", e);
        }
    }

    @Override
    public void setValue(Object context, Object value) {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            beanWrapper.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
            beanWrapper.setAutoGrowCollectionLimit(this.autoGrowCollectionLimit);
            beanWrapper.setConversionService(this.conversionService.getDelegateConversionService());
            beanWrapper.setPropertyValue(this.expression, value);
        }
        catch (NotWritablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (TypeMismatchException e) {
            throw new ValueCoercionException(context.getClass(), this.expression, value, e.getRequiredType(), e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "A BeansException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "] to [" + String.valueOf(value) + "]", e);
        }
    }

    @Override
    public Class<?> getValueType(Object context) {
        try {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(context);
            return beanWrapper.getPropertyType(this.expression);
        }
        catch (NotReadablePropertyException e) {
            throw new PropertyNotFoundException(context.getClass(), this.expression, e);
        }
        catch (BeansException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An BeansException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(context.getClass()) + "]", e);
        }
    }

    @Override
    public String getExpressionString() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }
}

