/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.statemachine.boot.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.repository.configuration.EnableRedisRepositories;
import org.springframework.statemachine.data.redis.RedisRepositoryState;
import org.springframework.statemachine.data.redis.RedisStateRepository;

/**
 * {@link EnableAutoConfiguration Auto-configuration} for Redis repositories
 * and Entity classes.
 */
@Configuration
@ConditionalOnClass(RedisStateRepository.class)
@ConditionalOnProperty(prefix = "spring.statemachine.data.redis.repositories", name = "enabled", havingValue = "true", matchIfMissing = true)
@AutoConfigureAfter(RedisRepositoriesAutoConfiguration.class)
@EntityScan(basePackageClasses = { RedisRepositoryState.class })
@EnableRedisRepositories(basePackageClasses = { RedisStateRepository.class })
public class StateMachineRedisRepositoriesAutoConfiguration {

}
