/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.jta.WebLogicJtaTransactionManager;
import org.springframework.transaction.jta.WebSphereUowTransactionManager;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class JtaTransactionManagerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final boolean weblogicPresent = ClassUtils.isPresent("weblogic.transaction.UserTransaction");
    private static final boolean webspherePresent = ClassUtils.isPresent("com.ibm.wsspi.uow.UOWManager");

    protected Class getBeanClass(Element element) {
        if (weblogicPresent) {
            return WebLogicJtaTransactionManager.class;
        }
        if (webspherePresent) {
            return WebSphereUowTransactionManager.class;
        }
        return JtaTransactionManager.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
    }
}

