/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.weaving;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.instrument.InstrumentationSavingAgent;
import org.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.ReflectiveLoadTimeWeaver;
import org.springframework.instrument.classloading.glassfish.GlassFishLoadTimeWeaver;
import org.springframework.instrument.classloading.oc4j.OC4JLoadTimeWeaver;
import org.springframework.instrument.classloading.weblogic.WebLogicLoadTimeWeaver;

public class DefaultContextLoadTimeWeaver
implements LoadTimeWeaver,
BeanClassLoaderAware {
    private LoadTimeWeaver loadTimeWeaver;

    public void setBeanClassLoader(ClassLoader classLoader) {
        try {
            String loaderClassName = classLoader.getClass().getName();
            this.loadTimeWeaver = loaderClassName.startsWith("com.sun.enterprise") ? new GlassFishLoadTimeWeaver(classLoader) : (loaderClassName.startsWith("oracle") ? new OC4JLoadTimeWeaver(classLoader) : (loaderClassName.startsWith("weblogic") ? new WebLogicLoadTimeWeaver(classLoader) : (InstrumentationSavingAgent.getInstrumentation() != null ? new InstrumentationLoadTimeWeaver() : new ReflectiveLoadTimeWeaver())));
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException(ex.getMessage() + " Specify a custom LoadTimeWeaver " + "or start your Java virtual machine with Spring's agent: -javaagent:spring-agent.jar");
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to build appropriate LoadTimeWeaver - make sure that that all required classes are on the classpath: " + ex);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.loadTimeWeaver.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.loadTimeWeaver.getInstrumentableClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.loadTimeWeaver.getThrowawayClassLoader();
    }
}

