/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements PriorityOrdered,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(AutowiredAnnotationBeanPostProcessor.class);
    private Class<? extends Annotation> autowiredAnnotationType = Autowired.class;
    private String requiredParameterName = "required";
    private boolean requiredParameterValue = true;
    private int order = Integer.MAX_VALUE;
    private ConfigurableListableBeanFactory beanFactory;
    private final transient Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        Assert.notNull(autowiredAnnotationType, "'autowiredAnnotationType' must not be null");
        this.autowiredAnnotationType = autowiredAnnotationType;
    }

    protected Class<? extends Annotation> getAutowiredAnnotationType() {
        return this.autowiredAnnotationType;
    }

    public void setRequiredParameterName(String requiredParameterName) {
        this.requiredParameterName = requiredParameterName;
    }

    public void setRequiredParameterValue(boolean requiredParameterValue) {
        this.requiredParameterValue = requiredParameterValue;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public Constructor[] determineCandidateConstructors(Class beanClass, String beanName) throws BeansException {
        Constructor<?>[] rawCandidates = beanClass.getDeclaredConstructors();
        ArrayList candidates = new ArrayList(rawCandidates.length);
        Constructor<?> requiredConstructor = null;
        Constructor<?> defaultConstructor = null;
        for (int i = 0; i < rawCandidates.length; ++i) {
            Constructor<?> candidate = rawCandidates[i];
            Annotation annotation = candidate.getAnnotation(this.getAutowiredAnnotationType());
            if (annotation != null) {
                if (requiredConstructor != null) {
                    throw new BeanCreationException("Invalid autowire-marked constructor: " + candidate + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                }
                if (candidate.getParameterTypes().length == 0) {
                    throw new IllegalStateException("Autowired annotation requires at least one argument: " + candidate);
                }
                boolean required = this.determineRequiredStatus(annotation);
                if (required) {
                    if (!candidates.isEmpty()) {
                        throw new BeanCreationException("Invalid autowire-marked constructors: " + candidates + ". Found another constructor with 'required' Autowired annotation: " + requiredConstructor);
                    }
                    requiredConstructor = candidate;
                }
                candidates.add(candidate);
                continue;
            }
            if (candidate.getParameterTypes().length != 0) continue;
            defaultConstructor = candidate;
        }
        if (!candidates.isEmpty()) {
            if (requiredConstructor == null && defaultConstructor != null) {
                candidates.add(defaultConstructor);
            }
            return candidates.toArray(new Constructor[candidates.size()]);
        }
        return null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.injectFields(bean, beanName);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Autowiring of fields failed", ex);
        }
        return true;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAutowiringMetadata(bean.getClass());
        try {
            metadata.injectMethods(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Autowiring of methods failed", ex);
        }
        return pvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAutowiringMetadata(Class clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    final InjectionMetadata newMetadata = new InjectionMetadata();
                    ReflectionUtils.doWithFields(clazz, new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) {
                            Annotation annotation = field.getAnnotation(AutowiredAnnotationBeanPostProcessor.this.getAutowiredAnnotationType());
                            if (annotation != null) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("Autowired annotation is not supported on static fields");
                                }
                                boolean required = AutowiredAnnotationBeanPostProcessor.this.determineRequiredStatus(annotation);
                                newMetadata.addInjectedField(new AutowiredElement(field, required, null));
                            }
                        }
                    });
                    ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) {
                            Annotation annotation = method.getAnnotation(AutowiredAnnotationBeanPostProcessor.this.getAutowiredAnnotationType());
                            if (annotation != null) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    throw new IllegalStateException("Autowired annotation is not supported on static methods");
                                }
                                if (method.getParameterTypes().length == 0) {
                                    throw new IllegalStateException("Autowired annotation requires at least one argument: " + method);
                                }
                                boolean required = AutowiredAnnotationBeanPostProcessor.this.determineRequiredStatus(annotation);
                                PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
                                newMetadata.addInjectedMethod(new AutowiredElement(method, required, pd));
                            }
                        }
                    });
                    metadata = newMetadata;
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected Map findAutowireCandidates(Class type) throws BeansException {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory configured - override the getBeanOfType method or specify the 'beanFactory' property");
        }
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type);
    }

    protected boolean determineRequiredStatus(Annotation annotation) {
        try {
            Method method = ReflectionUtils.findMethod(annotation.annotationType(), this.requiredParameterName);
            return this.requiredParameterValue == (Boolean)ReflectionUtils.invokeMethod(method, annotation);
        }
        catch (Exception ex) {
            return true;
        }
    }

    static /* synthetic */ ConfigurableListableBeanFactory access$000(AutowiredAnnotationBeanPostProcessor x0) {
        return x0.beanFactory;
    }

    private class AutowiredElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private final PropertyDescriptor pd;

        public AutowiredElement(Member member, boolean required, PropertyDescriptor pd) {
            super(member);
            this.required = required;
            this.pd = pd;
        }

        /*
         * Unable to fully structure code
         */
        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            autowiredBeanNames = new LinkedHashSet<E>(4);
            typeConverter = AutowiredAnnotationBeanPostProcessor.access$000(AutowiredAnnotationBeanPostProcessor.this).getTypeConverter();
            if (this.isField) {
                field = (Field)this.member;
                try {
                    argument = AutowiredAnnotationBeanPostProcessor.access$000(AutowiredAnnotationBeanPostProcessor.this).resolveDependency(new DependencyDescriptor(field, this.required), beanName, autowiredBeanNames, typeConverter);
                    if (argument == null) ** GOTO lbl33
                    ReflectionUtils.makeAccessible(field);
                    field.set(bean, argument);
                }
                catch (Throwable ex) {
                    throw new BeanCreationException("Could not autowire field: " + field, ex);
                }
            } else {
                if (this.pd != null && pvs != null && pvs.contains(this.pd.getName())) {
                    return;
                }
                method = (Method)this.member;
                arguments = new Object[method.getParameterTypes().length];
                try {
                    shouldInvoke = true;
                    for (i = 0; i < arguments.length; ++i) {
                        arguments[i] = AutowiredAnnotationBeanPostProcessor.access$000(AutowiredAnnotationBeanPostProcessor.this).resolveDependency(new DependencyDescriptor(new MethodParameter(method, i), this.required), beanName, autowiredBeanNames, typeConverter);
                        if (arguments[i] != null) continue;
                        shouldInvoke = false;
                    }
                    if (shouldInvoke) {
                        ReflectionUtils.makeAccessible(method);
                        method.invoke(bean, arguments);
                    }
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
                catch (Throwable ex) {
                    throw new BeanCreationException("Could not autowire method: " + method, ex);
                }
            }
lbl33:
            // 5 sources

            for (String autowiredBeanName : autowiredBeanNames) {
                AutowiredAnnotationBeanPostProcessor.access$000(AutowiredAnnotationBeanPostProcessor.this).registerDependentBean(autowiredBeanName, beanName);
                if (!AutowiredAnnotationBeanPostProcessor.this.logger.isDebugEnabled()) continue;
                AutowiredAnnotationBeanPostProcessor.this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via " + (this.isField != false ? "field" : "configuration method") + " to bean named '" + autowiredBeanName + "'"));
            }
        }
    }
}

