/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import jakarta.servlet.ServletContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.StandardWebSocketUpgradeStrategy;
import org.springframework.web.socket.server.support.AbstractHandshakeHandler;

public class DefaultHandshakeHandler
extends AbstractHandshakeHandler
implements ServletContextAware {
    private static final boolean JETTY_WS_PRESENT = ClassUtils.isPresent((String)"org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServerContainer", (ClassLoader)DefaultHandshakeHandler.class.getClassLoader());

    public DefaultHandshakeHandler() {
        super(JETTY_WS_PRESENT ? new JettyRequestUpgradeStrategy() : new StandardWebSocketUpgradeStrategy());
    }

    public DefaultHandshakeHandler(RequestUpgradeStrategy requestUpgradeStrategy) {
        super(requestUpgradeStrategy);
    }

    public void setServletContext(ServletContext servletContext) {
        RequestUpgradeStrategy strategy = this.getRequestUpgradeStrategy();
        if (strategy instanceof ServletContextAware) {
            ServletContextAware servletContextAware = (ServletContextAware)strategy;
            servletContextAware.setServletContext(servletContext);
        }
    }
}

