/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.CustomScopeConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.SimpSessionScope;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.OrderedMessageChannelDecorator;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.WebSocketMessageBrokerStats;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebMvcStompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;
import org.springframework.web.socket.messaging.DefaultSimpUserRegistry;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.messaging.WebSocketAnnotationMethodMessageHandler;
import org.springframework.web.socket.server.support.WebSocketHandlerMapping;

public abstract class WebSocketMessageBrokerConfigurationSupport
extends AbstractMessageBrokerConfiguration {
    private @Nullable WebSocketTransportRegistration transportRegistration;

    protected SimpAnnotationMethodMessageHandler createAnnotationMethodMessageHandler(AbstractSubscribableChannel clientInboundChannel, AbstractSubscribableChannel clientOutboundChannel, SimpMessagingTemplate brokerMessagingTemplate) {
        WebSocketAnnotationMethodMessageHandler handler = new WebSocketAnnotationMethodMessageHandler((SubscribableChannel)clientInboundChannel, (MessageChannel)clientOutboundChannel, (SimpMessageSendingOperations)brokerMessagingTemplate);
        handler.setPhase(this.getPhase());
        return handler;
    }

    protected SimpUserRegistry createLocalUserRegistry(@Nullable Integer order) {
        DefaultSimpUserRegistry registry = new DefaultSimpUserRegistry();
        if (order != null) {
            registry.setOrder(order);
        }
        return registry;
    }

    @Bean
    public HandlerMapping stompWebSocketHandlerMapping(WebSocketHandler subProtocolWebSocketHandler, TaskScheduler messageBrokerTaskScheduler, AbstractSubscribableChannel clientInboundChannel) {
        WebSocketHandler handler = this.decorateWebSocketHandler(subProtocolWebSocketHandler);
        WebMvcStompEndpointRegistry registry = new WebMvcStompEndpointRegistry(handler, this.getTransportRegistration(), messageBrokerTaskScheduler);
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            registry.setApplicationContext(applicationContext);
        }
        this.registerStompEndpoints(registry);
        OrderedMessageChannelDecorator.configureInterceptor((MessageChannel)clientInboundChannel, (boolean)registry.isPreserveReceiveOrder());
        AbstractHandlerMapping handlerMapping = registry.getHandlerMapping();
        if (handlerMapping instanceof WebSocketHandlerMapping) {
            WebSocketHandlerMapping webSocketMapping = (WebSocketHandlerMapping)handlerMapping;
            webSocketMapping.setPhase(this.getPhase());
        }
        return handlerMapping;
    }

    @Bean
    public WebSocketHandler subProtocolWebSocketHandler(AbstractSubscribableChannel clientInboundChannel, AbstractSubscribableChannel clientOutboundChannel) {
        SubProtocolWebSocketHandler handler = new SubProtocolWebSocketHandler((MessageChannel)clientInboundChannel, (SubscribableChannel)clientOutboundChannel);
        handler.setPhase(this.getPhase());
        return handler;
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        for (WebSocketHandlerDecoratorFactory factory : this.getTransportRegistration().getDecoratorFactories()) {
            handler = factory.decorate(handler);
        }
        return handler;
    }

    protected final WebSocketTransportRegistration getTransportRegistration() {
        if (this.transportRegistration == null) {
            this.transportRegistration = new WebSocketTransportRegistration();
            this.configureWebSocketTransport(this.transportRegistration);
        }
        return this.transportRegistration;
    }

    protected void configureWebSocketTransport(WebSocketTransportRegistration registry) {
    }

    protected abstract void registerStompEndpoints(StompEndpointRegistry var1);

    @Bean
    public static CustomScopeConfigurer webSocketScopeConfigurer() {
        CustomScopeConfigurer configurer = new CustomScopeConfigurer();
        configurer.addScope("websocket", (Scope)new SimpSessionScope());
        return configurer;
    }

    @Bean
    public WebSocketMessageBrokerStats webSocketMessageBrokerStats(@Nullable AbstractBrokerMessageHandler stompBrokerRelayMessageHandler, WebSocketHandler subProtocolWebSocketHandler, @Qualifier(value="clientInboundChannelExecutor") TaskExecutor inboundExecutor, @Qualifier(value="clientOutboundChannelExecutor") TaskExecutor outboundExecutor, @Qualifier(value="messageBrokerTaskScheduler") TaskScheduler scheduler) {
        WebSocketMessageBrokerStats stats = new WebSocketMessageBrokerStats();
        stats.setSubProtocolWebSocketHandler((SubProtocolWebSocketHandler)subProtocolWebSocketHandler);
        if (stompBrokerRelayMessageHandler instanceof StompBrokerRelayMessageHandler) {
            StompBrokerRelayMessageHandler sbrmh = (StompBrokerRelayMessageHandler)stompBrokerRelayMessageHandler;
            stats.setStompBrokerRelay(sbrmh);
        }
        stats.setInboundChannelExecutor(inboundExecutor);
        stats.setOutboundChannelExecutor(outboundExecutor);
        stats.setSockJsTaskScheduler(scheduler);
        return stats;
    }
}

