/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportType;
import org.springframework.web.socket.sockjs.transport.handler.AbstractHttpReceivingTransportHandler;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;

public class JsonpReceivingTransportHandler
extends AbstractHttpReceivingTransportHandler {
    private final FormHttpMessageConverter formConverter = new FormHttpMessageConverter();

    @Override
    public TransportType getTransportType() {
        return TransportType.JSONP_SEND;
    }

    @Override
    public void handleRequestInternal(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, AbstractHttpSockJsSession sockJsSession) throws SockJsException {
        super.handleRequestInternal(request, response, wsHandler, sockJsSession);
        try {
            response.getBody().write("ok".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new SockJsException("Failed to write to the response body", sockJsSession.getId(), ex);
        }
    }

    @Override
    @Nullable
    protected String[] readMessages(ServerHttpRequest request) throws IOException {
        SockJsMessageCodec messageCodec = this.getServiceConfig().getMessageCodec();
        MediaType contentType = request.getHeaders().getContentType();
        if (contentType != null && MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
            MultiValueMap map = this.formConverter.read(null, (HttpInputMessage)request);
            String d = (String)map.getFirst((Object)"d");
            return StringUtils.hasText((String)d) ? messageCodec.decode(d) : null;
        }
        return messageCodec.decodeInputStream(request.getBody());
    }

    @Override
    protected HttpStatus getResponseStatus() {
        return HttpStatus.OK;
    }
}

