/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.SessionLimitExceededException;
import org.springframework.web.socket.handler.WebSocketSessionDecorator;

public class ConcurrentWebSocketSessionDecorator
extends WebSocketSessionDecorator {
    private static final Log logger = LogFactory.getLog(ConcurrentWebSocketSessionDecorator.class);
    private final Queue<WebSocketMessage<?>> buffer = new LinkedBlockingQueue();
    private final AtomicInteger bufferSize = new AtomicInteger();
    private final int bufferSizeLimit;
    private volatile long sendStartTime;
    private final int sendTimeLimit;
    private volatile boolean limitExceeded;
    private volatile boolean shutdownInProgress;
    private final Lock flushLock = new ReentrantLock();
    private final Lock closeLock = new ReentrantLock();

    public ConcurrentWebSocketSessionDecorator(WebSocketSession delegate, int sendTimeLimit, int bufferSizeLimit) {
        super(delegate);
        this.sendTimeLimit = sendTimeLimit;
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public int getBufferSize() {
        return this.bufferSize.get();
    }

    public long getTimeSinceSendStarted() {
        long start = this.sendStartTime;
        return start > 0L ? System.currentTimeMillis() - start : 0L;
    }

    @Override
    public void sendMessage(WebSocketMessage<?> message) throws IOException {
        if (this.isDisabled()) {
            return;
        }
        this.buffer.add(message);
        this.bufferSize.addAndGet(message.getPayloadLength());
        do {
            if (this.tryFlushMessageBuffer()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Another send already in progress, session id '" + this.getId() + "'" + ", in-progress send time " + this.getTimeSinceSendStarted() + " (ms)" + ", buffer size " + this.bufferSize + " bytes"));
            }
            this.checkSessionLimits();
            break;
        } while (!this.buffer.isEmpty() && !this.isDisabled());
    }

    private boolean isDisabled() {
        return this.limitExceeded || this.shutdownInProgress;
    }

    private boolean tryFlushMessageBuffer() throws IOException {
        if (this.flushLock.tryLock()) {
            try {
                WebSocketMessage<?> messageToSend;
                while ((messageToSend = this.buffer.poll()) != null) {
                    if (this.isDisabled()) {
                        break;
                    }
                    this.bufferSize.addAndGet(messageToSend.getPayloadLength() * -1);
                    this.sendStartTime = System.currentTimeMillis();
                    this.getDelegate().sendMessage(messageToSend);
                    this.sendStartTime = 0L;
                }
            }
            finally {
                this.sendStartTime = 0L;
                this.flushLock.unlock();
            }
            return true;
        }
        return false;
    }

    private void checkSessionLimits() throws IOException {
        if (!this.isDisabled() && this.closeLock.tryLock()) {
            try {
                if (this.getTimeSinceSendStarted() > (long)this.sendTimeLimit) {
                    String errorMessage = "Message send time " + this.getTimeSinceSendStarted() + " (ms) exceeded the allowed limit " + this.sendTimeLimit;
                    this.sessionLimitReached(errorMessage, CloseStatus.SESSION_NOT_RELIABLE);
                } else if (this.bufferSize.get() > this.bufferSizeLimit) {
                    String errorMessage = "The send buffer size " + this.bufferSize.get() + " bytes for " + "session '" + this.getId() + " exceeded the allowed limit " + this.bufferSizeLimit;
                    this.sessionLimitReached(errorMessage, this.getTimeSinceSendStarted() >= 10000L ? CloseStatus.SESSION_NOT_RELIABLE : null);
                }
            }
            finally {
                this.closeLock.unlock();
            }
        }
    }

    private void sessionLimitReached(String reason, CloseStatus status) {
        this.limitExceeded = true;
        throw new SessionLimitExceededException(reason, status);
    }

    @Override
    public void close(CloseStatus status) throws IOException {
        this.shutdownInProgress = true;
        super.close(status);
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }
}

