/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import javax.servlet.ServletContext;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerContainer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

public class ServletServerContainerFactoryBean
implements FactoryBean<WebSocketContainer>,
ServletContextAware,
InitializingBean {
    private Long asyncSendTimeout;
    private Long maxSessionIdleTimeout;
    private Integer maxTextMessageBufferSize;
    private Integer maxBinaryMessageBufferSize;
    private ServerContainer serverContainer;

    public void setAsyncSendTimeout(long timeoutInMillis) {
        this.asyncSendTimeout = timeoutInMillis;
    }

    public long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setMaxSessionIdleTimeout(long timeoutInMillis) {
        this.maxSessionIdleTimeout = timeoutInMillis;
    }

    public Long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxTextMessageBufferSize(int bufferSize) {
        this.maxTextMessageBufferSize = bufferSize;
    }

    public Integer getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(int bufferSize) {
        this.maxBinaryMessageBufferSize = bufferSize;
    }

    public Integer getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setServletContext(ServletContext servletContext) {
        this.serverContainer = (ServerContainer)servletContext.getAttribute("javax.websocket.server.ServerContainer");
    }

    public void afterPropertiesSet() {
        Assert.state((this.serverContainer != null ? 1 : 0) != 0, (String)"A ServletContext is required to access the javax.websocket.server.ServerContainer instance");
        if (this.asyncSendTimeout != null) {
            this.serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxSessionIdleTimeout != null) {
            this.serverContainer.setDefaultMaxSessionIdleTimeout(this.maxSessionIdleTimeout.longValue());
        }
        if (this.maxTextMessageBufferSize != null) {
            this.serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageBufferSize.intValue());
        }
        if (this.maxBinaryMessageBufferSize != null) {
            this.serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize.intValue());
        }
    }

    public ServerContainer getObject() {
        return this.serverContainer;
    }

    public Class<?> getObjectType() {
        return this.serverContainer != null ? this.serverContainer.getClass() : ServerContainer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

