/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.cbor.JacksonCborHttpMessageConverter;
import org.springframework.http.converter.cbor.KotlinSerializationCborHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.protobuf.KotlinSerializationProtobufHttpMessageConverter;
import org.springframework.http.converter.smile.JacksonSmileHttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.JacksonXmlHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.yaml.JacksonYamlHttpMessageConverter;
import org.springframework.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean;
import org.springframework.web.ErrorResponse;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.support.CompositeUriComponentsContributor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ApiVersionConfigurer;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.function.support.HandlerFunctionAdapter;
import org.springframework.web.servlet.function.support.RouterFunctionMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewRequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.KotlinRequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.KotlinResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.ViewResolverComposite;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

public class WebMvcConfigurationSupport
implements ApplicationContextAware,
ServletContextAware {
    private static final boolean romePresent;
    private static final boolean jaxb2Present;
    private static final boolean jacksonPresent;
    private static final boolean jackson2Present;
    private static final boolean jacksonXmlPresent;
    private static final boolean jackson2XmlPresent;
    private static final boolean jacksonSmilePresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean jacksonCborPresent;
    private static final boolean jackson2CborPresent;
    private static final boolean jacksonYamlPresent;
    private static final boolean jackson2YamlPresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean kotlinSerializationPresent;
    private static final boolean kotlinSerializationCborPresent;
    private static final boolean kotlinSerializationJsonPresent;
    private static final boolean kotlinSerializationProtobufPresent;
    private @Nullable ApplicationContext applicationContext;
    private @Nullable ServletContext servletContext;
    private @Nullable List<Object> interceptors;
    private @Nullable PathMatchConfigurer pathMatchConfigurer;
    private @Nullable ContentNegotiationManager contentNegotiationManager;
    private @Nullable ApiVersionStrategy apiVersionStrategy;
    private @Nullable List<HandlerMethodArgumentResolver> argumentResolvers;
    private @Nullable List<HandlerMethodReturnValueHandler> returnValueHandlers;
    private @Nullable List<HttpMessageConverter<?>> messageConverters;
    private @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    ErrorResponse.Interceptor> errorResponseInterceptors;
    private @Nullable Map<String, CorsConfiguration> corsConfigurations;
    private @Nullable AsyncSupportConfigurer asyncSupportConfigurer;

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public final @Nullable ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public final @Nullable ServletContext getServletContext() {
        return this.servletContext;
    }

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, @Qualifier(value="mvcApiVersionStrategy") @Nullable ApiVersionStrategy apiVersionStrategy, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        RequestMappingHandlerMapping mapping = this.createRequestMappingHandlerMapping();
        mapping.setOrder(0);
        mapping.setContentNegotiationManager(contentNegotiationManager);
        mapping.setApiVersionStrategy(apiVersionStrategy);
        this.initHandlerMapping(mapping, conversionService, resourceUrlProvider);
        PathMatchConfigurer pathConfig = this.getPathMatchConfigurer();
        if (pathConfig.getPathPrefixes() != null) {
            mapping.setPathPrefixes(pathConfig.getPathPrefixes());
        }
        return mapping;
    }

    protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
        return new RequestMappingHandlerMapping();
    }

    protected final Object[] getInterceptors(FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
        if (this.interceptors == null) {
            InterceptorRegistry registry = new InterceptorRegistry();
            this.addInterceptors(registry);
            registry.addInterceptor(new ConversionServiceExposingInterceptor((ConversionService)mvcConversionService));
            registry.addInterceptor(new ResourceUrlProviderExposingInterceptor(mvcResourceUrlProvider));
            this.interceptors = registry.getInterceptors();
        }
        return this.interceptors.toArray();
    }

    protected void addInterceptors(InterceptorRegistry registry) {
    }

    protected PathMatchConfigurer getPathMatchConfigurer() {
        if (this.pathMatchConfigurer == null) {
            this.pathMatchConfigurer = new PathMatchConfigurer();
            this.configurePathMatch(this.pathMatchConfigurer);
        }
        return this.pathMatchConfigurer;
    }

    protected void configurePathMatch(PathMatchConfigurer configurer) {
    }

    @Bean
    public PathPatternParser mvcPatternParser() {
        return this.getPathMatchConfigurer().getPatternParserOrDefault();
    }

    @Deprecated(since="7.0", forRemoval=true)
    @Bean
    public UrlPathHelper mvcUrlPathHelper() {
        return this.getPathMatchConfigurer().getUrlPathHelperOrDefault();
    }

    @Deprecated(since="7.0", forRemoval=true)
    @Bean
    public PathMatcher mvcPathMatcher() {
        return this.getPathMatchConfigurer().getPathMatcherOrDefault();
    }

    @Bean
    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            ContentNegotiationConfigurer configurer = new ContentNegotiationConfigurer();
            configurer.mediaTypes(this.getDefaultMediaTypes());
            this.configureContentNegotiation(configurer);
            this.contentNegotiationManager = configurer.buildContentNegotiationManager();
        }
        return this.contentNegotiationManager;
    }

    protected Map<String, MediaType> getDefaultMediaTypes() {
        HashMap<String, MediaType> map = new HashMap<String, MediaType>(4);
        if (romePresent) {
            map.put("atom", MediaType.APPLICATION_ATOM_XML);
            map.put("rss", MediaType.APPLICATION_RSS_XML);
        }
        if (jaxb2Present || jacksonXmlPresent || jackson2XmlPresent) {
            map.put("xml", MediaType.APPLICATION_XML);
        }
        if (jacksonPresent || jackson2Present || gsonPresent || jsonbPresent || kotlinSerializationJsonPresent) {
            map.put("json", MediaType.APPLICATION_JSON);
        }
        if (jacksonSmilePresent || jackson2SmilePresent) {
            map.put("smile", MediaType.valueOf((String)"application/x-jackson-smile"));
        }
        if (jacksonCborPresent || jackson2CborPresent || kotlinSerializationCborPresent) {
            map.put("cbor", MediaType.APPLICATION_CBOR);
        }
        if (jacksonYamlPresent || jackson2YamlPresent) {
            map.put("yaml", MediaType.APPLICATION_YAML);
        }
        return map;
    }

    protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    @Bean
    public @Nullable ApiVersionStrategy mvcApiVersionStrategy() {
        if (this.apiVersionStrategy == null) {
            ApiVersionConfigurer configurer = new ApiVersionConfigurer();
            this.configureApiVersioning(configurer);
            ApiVersionStrategy strategy = configurer.getApiVersionStrategy();
            if (strategy != null) {
                this.apiVersionStrategy = strategy;
            }
        }
        return this.apiVersionStrategy;
    }

    protected void configureApiVersioning(ApiVersionConfigurer configurer) {
    }

    @Bean
    public @Nullable HandlerMapping viewControllerHandlerMapping(@Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        ViewControllerRegistry registry = new ViewControllerRegistry(this.applicationContext);
        this.addViewControllers(registry);
        SimpleUrlHandlerMapping mapping = registry.buildHandlerMapping();
        this.initHandlerMapping(mapping, conversionService, resourceUrlProvider);
        return mapping;
    }

    private void initHandlerMapping(@Nullable AbstractHandlerMapping mapping, FormattingConversionService conversionService, ResourceUrlProvider resourceUrlProvider) {
        if (mapping == null) {
            return;
        }
        PathMatchConfigurer pathConfig = this.getPathMatchConfigurer();
        if (pathConfig.preferPathMatcher()) {
            mapping.setPatternParser(null);
            mapping.setUrlPathHelper(pathConfig.getUrlPathHelperOrDefault());
            mapping.setPathMatcher(pathConfig.getPathMatcherOrDefault());
        } else if (pathConfig.getPatternParser() != null) {
            mapping.setPatternParser(pathConfig.getPatternParser());
        }
        mapping.setInterceptors(this.getInterceptors(conversionService, resourceUrlProvider));
        mapping.setCorsConfigurations(this.getCorsConfigurations());
    }

    protected void addViewControllers(ViewControllerRegistry registry) {
    }

    @Bean
    public BeanNameUrlHandlerMapping beanNameHandlerMapping(@Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        BeanNameUrlHandlerMapping mapping = new BeanNameUrlHandlerMapping();
        mapping.setOrder(2);
        this.initHandlerMapping(mapping, conversionService, resourceUrlProvider);
        return mapping;
    }

    @Bean
    public RouterFunctionMapping routerFunctionMapping(@Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        RouterFunctionMapping mapping = new RouterFunctionMapping();
        mapping.setOrder(-1);
        mapping.setInterceptors(this.getInterceptors(conversionService, resourceUrlProvider));
        mapping.setCorsConfigurations(this.getCorsConfigurations());
        mapping.setMessageConverters(this.getMessageConverters());
        PathPatternParser patternParser = this.getPathMatchConfigurer().getPatternParser();
        if (patternParser != null) {
            mapping.setPatternParser(patternParser);
        }
        return mapping;
    }

    @Bean
    public @Nullable HandlerMapping resourceHandlerMapping(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcResourceUrlProvider") ResourceUrlProvider resourceUrlProvider) {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext set");
        Assert.state((this.servletContext != null ? 1 : 0) != 0, (String)"No ServletContext set");
        PathMatchConfigurer pathConfig = this.getPathMatchConfigurer();
        ResourceHandlerRegistry registry = new ResourceHandlerRegistry(this.applicationContext, this.servletContext, contentNegotiationManager, pathConfig.getUrlPathHelper());
        this.addResourceHandlers(registry);
        AbstractHandlerMapping mapping = registry.getHandlerMapping();
        this.initHandlerMapping(mapping, conversionService, resourceUrlProvider);
        return mapping;
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
    }

    @Bean
    public ResourceUrlProvider mvcResourceUrlProvider() {
        ResourceUrlProvider urlProvider = new ResourceUrlProvider();
        urlProvider.setUrlPathHelper(this.getPathMatchConfigurer().getUrlPathHelperOrDefault());
        urlProvider.setPathMatcher(this.getPathMatchConfigurer().getPathMatcherOrDefault());
        return urlProvider;
    }

    @Bean
    public @Nullable HandlerMapping defaultServletHandlerMapping() {
        Assert.state((this.servletContext != null ? 1 : 0) != 0, (String)"No ServletContext set");
        DefaultServletHandlerConfigurer configurer = new DefaultServletHandlerConfigurer(this.servletContext);
        this.configureDefaultServletHandling(configurer);
        return configurer.buildHandlerMapping();
    }

    protected void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    @Bean
    public RequestMappingHandlerAdapter requestMappingHandlerAdapter(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager, @Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="mvcValidator") Validator validator) {
        AsyncSupportConfigurer configurer;
        RequestMappingHandlerAdapter adapter = this.createRequestMappingHandlerAdapter();
        adapter.setContentNegotiationManager(contentNegotiationManager);
        adapter.setMessageConverters(this.getMessageConverters());
        adapter.setWebBindingInitializer((WebBindingInitializer)this.getConfigurableWebBindingInitializer(conversionService, validator));
        adapter.setCustomArgumentResolvers(this.getArgumentResolvers());
        adapter.setCustomReturnValueHandlers(this.getReturnValueHandlers());
        adapter.setErrorResponseInterceptors(this.getErrorResponseInterceptors());
        if (jacksonPresent || jackson2Present || kotlinSerializationPresent) {
            ArrayList<RequestBodyAdvice> requestBodyAdvices = new ArrayList<RequestBodyAdvice>(2);
            ArrayList responseBodyAdvices = new ArrayList(2);
            if (jacksonPresent || jackson2Present) {
                requestBodyAdvices.add(new JsonViewRequestBodyAdvice());
                responseBodyAdvices.add(new JsonViewResponseBodyAdvice());
            }
            if (kotlinSerializationPresent) {
                requestBodyAdvices.add(new KotlinRequestBodyAdvice());
                responseBodyAdvices.add(new KotlinResponseBodyAdvice());
            }
            adapter.setRequestBodyAdvice(requestBodyAdvices);
            adapter.setResponseBodyAdvice(responseBodyAdvices);
        }
        if ((configurer = this.getAsyncSupportConfigurer()).getTaskExecutor() != null) {
            adapter.setTaskExecutor(configurer.getTaskExecutor());
        }
        if (configurer.getTimeout() != null) {
            adapter.setAsyncRequestTimeout(configurer.getTimeout());
        }
        adapter.setCallableInterceptors(configurer.getCallableInterceptors());
        adapter.setDeferredResultInterceptors(configurer.getDeferredResultInterceptors());
        return adapter;
    }

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new RequestMappingHandlerAdapter();
    }

    @Bean
    public HandlerFunctionAdapter handlerFunctionAdapter() {
        HandlerFunctionAdapter adapter = new HandlerFunctionAdapter();
        AsyncSupportConfigurer configurer = this.getAsyncSupportConfigurer();
        if (configurer.getTimeout() != null) {
            adapter.setAsyncRequestTimeout(configurer.getTimeout());
        }
        return adapter;
    }

    protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer(FormattingConversionService mvcConversionService, Validator mvcValidator) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService((ConversionService)mvcConversionService);
        initializer.setValidator(mvcValidator);
        MessageCodesResolver messageCodesResolver = this.getMessageCodesResolver();
        if (messageCodesResolver != null) {
            initializer.setMessageCodesResolver(messageCodesResolver);
        }
        return initializer;
    }

    protected @Nullable MessageCodesResolver getMessageCodesResolver() {
        return null;
    }

    @Bean
    public FormattingConversionService mvcConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        this.addFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    protected void addFormatters(FormatterRegistry registry) {
    }

    @Bean
    public Validator mvcValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (ClassUtils.isPresent((String)"jakarta.validation.Validator", (ClassLoader)this.getClass().getClassLoader())) {
                try {
                    validator = new OptionalValidatorFactoryBean();
                }
                catch (Throwable ex) {
                    throw new BeanInitializationException("Failed to create default validator", ex);
                }
            } else {
                validator = new NoOpValidator();
            }
        }
        return validator;
    }

    protected @Nullable Validator getValidator() {
        return null;
    }

    protected final List<HandlerMethodArgumentResolver> getArgumentResolvers() {
        if (this.argumentResolvers == null) {
            this.argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
            this.addArgumentResolvers(this.argumentResolvers);
        }
        return this.argumentResolvers;
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    protected final List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        if (this.returnValueHandlers == null) {
            this.returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
            this.addReturnValueHandlers(this.returnValueHandlers);
        }
        return this.returnValueHandlers;
    }

    protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    protected final List<HttpMessageConverter<?>> getMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.configureMessageConverters(this.messageConverters);
            if (this.messageConverters.isEmpty()) {
                this.addDefaultHttpMessageConverters(this.messageConverters);
            }
            this.extendMessageConverters(this.messageConverters);
        }
        return this.messageConverters;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    protected final void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Jackson2ObjectMapperBuilder builder;
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
        if (jacksonXmlPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JacksonXmlHttpMessageConverter());
        } else if (jackson2XmlPresent) {
            builder = Jackson2ObjectMapperBuilder.xml();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter(builder.build()));
        } else if (jaxb2Present) {
            messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (kotlinSerializationProtobufPresent) {
            messageConverters.add((HttpMessageConverter<?>)new KotlinSerializationProtobufHttpMessageConverter());
        }
        if (jacksonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JacksonJsonHttpMessageConverter());
        } else if (jackson2Present) {
            builder = Jackson2ObjectMapperBuilder.json();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(builder.build()));
        } else if (gsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JsonbHttpMessageConverter());
        } else if (kotlinSerializationJsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new KotlinSerializationJsonHttpMessageConverter());
        }
        if (jacksonSmilePresent) {
            messageConverters.add((HttpMessageConverter<?>)new JacksonSmileHttpMessageConverter());
        } else if (jackson2SmilePresent) {
            builder = Jackson2ObjectMapperBuilder.smile();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2SmileHttpMessageConverter(builder.build()));
        }
        if (jacksonCborPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JacksonCborHttpMessageConverter());
        } else if (jackson2CborPresent) {
            builder = Jackson2ObjectMapperBuilder.cbor();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2CborHttpMessageConverter(builder.build()));
        } else if (kotlinSerializationCborPresent) {
            messageConverters.add((HttpMessageConverter<?>)new KotlinSerializationCborHttpMessageConverter());
        }
        if (jacksonYamlPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JacksonYamlHttpMessageConverter());
        } else if (jackson2YamlPresent) {
            builder = Jackson2ObjectMapperBuilder.yaml();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2YamlHttpMessageConverter(builder.build()));
        }
    }

    protected AsyncSupportConfigurer getAsyncSupportConfigurer() {
        if (this.asyncSupportConfigurer == null) {
            this.asyncSupportConfigurer = new AsyncSupportConfigurer();
            this.configureAsyncSupport(this.asyncSupportConfigurer);
        }
        return this.asyncSupportConfigurer;
    }

    protected void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    @Bean
    public CompositeUriComponentsContributor mvcUriComponentsContributor(@Qualifier(value="mvcConversionService") FormattingConversionService conversionService, @Qualifier(value="requestMappingHandlerAdapter") RequestMappingHandlerAdapter requestMappingHandlerAdapter) {
        return new CompositeUriComponentsContributor(requestMappingHandlerAdapter.getArgumentResolvers(), (ConversionService)conversionService);
    }

    @Bean
    public HttpRequestHandlerAdapter httpRequestHandlerAdapter() {
        return new HttpRequestHandlerAdapter();
    }

    @Bean
    public SimpleControllerHandlerAdapter simpleControllerHandlerAdapter() {
        return new SimpleControllerHandlerAdapter();
    }

    @Bean
    public HandlerExceptionResolver handlerExceptionResolver(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        ArrayList<HandlerExceptionResolver> exceptionResolvers = new ArrayList<HandlerExceptionResolver>();
        this.configureHandlerExceptionResolvers(exceptionResolvers);
        if (exceptionResolvers.isEmpty()) {
            this.addDefaultHandlerExceptionResolvers(exceptionResolvers, contentNegotiationManager);
        }
        this.extendHandlerExceptionResolvers(exceptionResolvers);
        HandlerExceptionResolverComposite composite = new HandlerExceptionResolverComposite();
        composite.setOrder(0);
        composite.setExceptionResolvers(exceptionResolvers);
        return composite;
    }

    protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    protected void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    protected final void addDefaultHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers, ContentNegotiationManager mvcContentNegotiationManager) {
        ExceptionHandlerExceptionResolver exceptionHandlerResolver = this.createExceptionHandlerExceptionResolver();
        exceptionHandlerResolver.setContentNegotiationManager(mvcContentNegotiationManager);
        exceptionHandlerResolver.setMessageConverters(this.getMessageConverters());
        exceptionHandlerResolver.setCustomArgumentResolvers(this.getArgumentResolvers());
        exceptionHandlerResolver.setCustomReturnValueHandlers(this.getReturnValueHandlers());
        exceptionHandlerResolver.setErrorResponseInterceptors(this.getErrorResponseInterceptors());
        if (jacksonPresent || jackson2Present || kotlinSerializationPresent) {
            ArrayList responseBodyAdvices = new ArrayList(2);
            if (jacksonPresent || jackson2Present) {
                responseBodyAdvices.add(new JsonViewResponseBodyAdvice());
            }
            if (kotlinSerializationPresent) {
                responseBodyAdvices.add(new KotlinResponseBodyAdvice());
            }
            exceptionHandlerResolver.setResponseBodyAdvice(responseBodyAdvices);
        }
        if (this.applicationContext != null) {
            exceptionHandlerResolver.setApplicationContext(this.applicationContext);
        }
        exceptionHandlerResolver.afterPropertiesSet();
        exceptionResolvers.add(exceptionHandlerResolver);
        ResponseStatusExceptionResolver responseStatusResolver = new ResponseStatusExceptionResolver();
        responseStatusResolver.setMessageSource((MessageSource)this.applicationContext);
        exceptionResolvers.add(responseStatusResolver);
        exceptionResolvers.add(new DefaultHandlerExceptionResolver());
    }

    protected ExceptionHandlerExceptionResolver createExceptionHandlerExceptionResolver() {
        return new ExceptionHandlerExceptionResolver();
    }

    protected final List<ErrorResponse.Interceptor> getErrorResponseInterceptors() {
        if (this.errorResponseInterceptors == null) {
            this.errorResponseInterceptors = new ArrayList<ErrorResponse.Interceptor>();
            this.configureErrorResponseInterceptors(this.errorResponseInterceptors);
        }
        return this.errorResponseInterceptors;
    }

    protected void configureErrorResponseInterceptors(List<ErrorResponse.Interceptor> interceptors) {
    }

    @Bean
    public ViewResolver mvcViewResolver(@Qualifier(value="mvcContentNegotiationManager") ContentNegotiationManager contentNegotiationManager) {
        String[] names;
        ViewResolverRegistry registry = new ViewResolverRegistry(contentNegotiationManager, this.applicationContext);
        this.configureViewResolvers(registry);
        if (registry.getViewResolvers().isEmpty() && this.applicationContext != null && (names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ViewResolver.class, (boolean)true, (boolean)false)).length == 1) {
            registry.getViewResolvers().add(new InternalResourceViewResolver());
        }
        ViewResolverComposite composite = new ViewResolverComposite();
        composite.setOrder(registry.getOrder());
        composite.setViewResolvers(registry.getViewResolvers());
        if (this.applicationContext != null) {
            composite.setApplicationContext(this.applicationContext);
        }
        if (this.servletContext != null) {
            composite.setServletContext(this.servletContext);
        }
        return composite;
    }

    protected void configureViewResolvers(ViewResolverRegistry registry) {
    }

    protected final Map<String, CorsConfiguration> getCorsConfigurations() {
        if (this.corsConfigurations == null) {
            CorsRegistry registry = new CorsRegistry();
            this.addCorsMappings(registry);
            this.corsConfigurations = registry.getCorsConfigurations();
        }
        return this.corsConfigurations;
    }

    protected void addCorsMappings(CorsRegistry registry) {
    }

    @Bean
    @Lazy
    public HandlerMappingIntrospector mvcHandlerMappingIntrospector() {
        return new HandlerMappingIntrospector();
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new AcceptHeaderLocaleResolver();
    }

    @Bean
    public FlashMapManager flashMapManager() {
        return new SessionFlashMapManager();
    }

    @Bean
    public RequestToViewNameTranslator viewNameTranslator() {
        return new DefaultRequestToViewNameTranslator();
    }

    static {
        ClassLoader classLoader = WebMvcConfigurationSupport.class.getClassLoader();
        romePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)classLoader);
        jaxb2Present = ClassUtils.isPresent((String)"jakarta.xml.bind.Binder", (ClassLoader)classLoader);
        jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)classLoader);
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        jacksonXmlPresent = jacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        jackson2XmlPresent = jackson2Present && ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
        jacksonSmilePresent = jacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.smile.SmileMapper", (ClassLoader)classLoader);
        jackson2SmilePresent = jackson2Present && ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
        jacksonCborPresent = jacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.cbor.CBORMapper", (ClassLoader)classLoader);
        jackson2CborPresent = jackson2Present && ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.cbor.CBORFactory", (ClassLoader)classLoader);
        jacksonYamlPresent = jacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.yaml.YAMLMapper", (ClassLoader)classLoader);
        jackson2YamlPresent = jackson2Present && ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.yaml.YAMLFactory", (ClassLoader)classLoader);
        gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
        jsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)classLoader);
        kotlinSerializationPresent = ClassUtils.isPresent((String)"kotlinx.serialization.Serializable", (ClassLoader)classLoader);
        kotlinSerializationCborPresent = kotlinSerializationPresent && ClassUtils.isPresent((String)"kotlinx.serialization.cbor.Cbor", (ClassLoader)classLoader);
        kotlinSerializationJsonPresent = kotlinSerializationPresent && ClassUtils.isPresent((String)"kotlinx.serialization.json.Json", (ClassLoader)classLoader);
        kotlinSerializationProtobufPresent = kotlinSerializationPresent && ClassUtils.isPresent((String)"kotlinx.serialization.protobuf.ProtoBuf", (ClassLoader)classLoader);
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(@Nullable Object target, Errors errors) {
        }
    }
}

