/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.NotAcceptableApiVersionException;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;

public final class VersionRequestCondition
extends AbstractRequestCondition<VersionRequestCondition> {
    private static final String VERSION_ATTRIBUTE_NAME = VersionRequestCondition.class.getName() + ".VERSION";
    private static final String NO_VERSION_ATTRIBUTE = "NO_VERSION";
    private static final ApiVersionStrategy NO_OP_VERSION_STRATEGY = new NoOpApiVersionStrategy();
    private final @Nullable String versionValue;
    private final @Nullable Object version;
    private final boolean baselineVersion;
    private final ApiVersionStrategy versionStrategy;
    private final Set<String> content;

    public VersionRequestCondition() {
        this.versionValue = null;
        this.version = null;
        this.baselineVersion = false;
        this.versionStrategy = NO_OP_VERSION_STRATEGY;
        this.content = Collections.emptySet();
    }

    public VersionRequestCondition(String configuredVersion, ApiVersionStrategy versionStrategy) {
        this.baselineVersion = configuredVersion.endsWith("+");
        this.versionValue = VersionRequestCondition.updateVersion(configuredVersion, this.baselineVersion);
        this.version = versionStrategy.parseVersion(this.versionValue);
        this.versionStrategy = versionStrategy;
        this.content = Set.of(configuredVersion);
    }

    private static String updateVersion(String version, boolean baselineVersion) {
        return baselineVersion ? version.substring(0, version.length() - 1) : version;
    }

    @Override
    protected Collection<String> getContent() {
        return this.content;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    public @Nullable String getVersion() {
        return this.versionValue;
    }

    @Override
    public VersionRequestCondition combine(VersionRequestCondition other) {
        return other.version != null ? other : this;
    }

    @Override
    public @Nullable VersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.version == null) {
            return this;
        }
        Object version = (Comparable)request.getAttribute(VERSION_ATTRIBUTE_NAME);
        if (version == null) {
            String value = this.versionStrategy.resolveVersion(request);
            version = value != null ? this.parseVersion(value) : this.versionStrategy.getDefaultVersion();
            this.versionStrategy.validateVersion((Comparable)version, request);
            version = version != null ? version : NO_VERSION_ATTRIBUTE;
            request.setAttribute(VERSION_ATTRIBUTE_NAME, version);
        }
        if (version == NO_VERSION_ATTRIBUTE) {
            return this;
        }
        int result = this.compareVersions(this.version, version);
        return result <= 0 ? this : null;
    }

    private Comparable<?> parseVersion(String value) {
        try {
            return this.versionStrategy.parseVersion(value);
        }
        catch (Exception ex) {
            throw new InvalidApiVersionException(value, null, ex);
        }
    }

    private <V extends Comparable<V>> int compareVersions(Object v1, Object v2) {
        return ((Comparable)v1).compareTo((Comparable)v2);
    }

    @Override
    public int compareTo(VersionRequestCondition other, HttpServletRequest request) {
        Object otherVersion = other.version;
        if (this.version == null && otherVersion == null) {
            return 0;
        }
        if (this.version != null && otherVersion != null) {
            return -1 * this.compareVersions(this.version, otherVersion);
        }
        return this.version != null ? -1 : 1;
    }

    public void handleMatch(HttpServletRequest request) {
        if (this.version != null && !this.baselineVersion) {
            Comparable version = (Comparable)request.getAttribute(VERSION_ATTRIBUTE_NAME);
            Assert.state((version != null ? 1 : 0) != 0, (String)"No API version attribute");
            if (!this.version.equals(version)) {
                throw new NotAcceptableApiVersionException(version.toString());
            }
        }
    }

    private static final class NoOpApiVersionStrategy
    implements ApiVersionStrategy {
        private NoOpApiVersionStrategy() {
        }

        public @Nullable String resolveVersion(HttpServletRequest request) {
            return null;
        }

        public String parseVersion(String version) {
            return version;
        }

        public void validateVersion(@Nullable Comparable<?> requestVersion, HttpServletRequest request) {
        }

        public @Nullable Comparable<?> getDefaultVersion() {
            return null;
        }
    }
}

