/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.i18n.AbstractLocaleContextResolver;
import org.springframework.web.util.WebUtils;

public class SessionLocaleResolver
extends AbstractLocaleContextResolver {
    public static final String LOCALE_SESSION_ATTRIBUTE_NAME = SessionLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_SESSION_ATTRIBUTE_NAME = SessionLocaleResolver.class.getName() + ".TIME_ZONE";
    private String localeAttributeName = LOCALE_SESSION_ATTRIBUTE_NAME;
    private String timeZoneAttributeName = TIME_ZONE_SESSION_ATTRIBUTE_NAME;
    private Function<HttpServletRequest, Locale> defaultLocaleFunction = request -> {
        Locale defaultLocale = this.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : request.getLocale();
    };
    private Function<HttpServletRequest, @Nullable TimeZone> defaultTimeZoneFunction = request -> this.getDefaultTimeZone();

    public void setLocaleAttributeName(String localeAttributeName) {
        this.localeAttributeName = localeAttributeName;
    }

    public void setTimeZoneAttributeName(String timeZoneAttributeName) {
        this.timeZoneAttributeName = timeZoneAttributeName;
    }

    public void setDefaultLocaleFunction(Function<HttpServletRequest, Locale> defaultLocaleFunction) {
        Assert.notNull(defaultLocaleFunction, (String)"defaultLocaleFunction must not be null");
        this.defaultLocaleFunction = defaultLocaleFunction;
    }

    public void setDefaultTimeZoneFunction(Function<HttpServletRequest, @Nullable TimeZone> defaultTimeZoneFunction) {
        Assert.notNull(defaultTimeZoneFunction, (String)"defaultTimeZoneFunction must not be null");
        this.defaultTimeZoneFunction = defaultTimeZoneFunction;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)this.localeAttributeName);
        if (locale == null) {
            locale = this.defaultLocaleFunction.apply(request);
        }
        return locale;
    }

    @Override
    public LocaleContext resolveLocaleContext(final HttpServletRequest request) {
        return new TimeZoneAwareLocaleContext(){
            final /* synthetic */ SessionLocaleResolver this$0;
            {
                this.this$0 = this$0;
            }

            public Locale getLocale() {
                Locale locale = (Locale)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)this.this$0.localeAttributeName);
                if (locale == null) {
                    locale = this.this$0.defaultLocaleFunction.apply(request);
                }
                return locale;
            }

            public @Nullable TimeZone getTimeZone() {
                TimeZone timeZone = (TimeZone)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)this.this$0.timeZoneAttributeName);
                if (timeZone == null) {
                    timeZone = this.this$0.defaultTimeZoneFunction.apply(request);
                }
                return timeZone;
            }
        };
    }

    @Override
    public void setLocaleContext(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable LocaleContext localeContext) {
        Locale locale = null;
        TimeZone timeZone = null;
        if (localeContext != null) {
            locale = localeContext.getLocale();
            if (localeContext instanceof TimeZoneAwareLocaleContext) {
                TimeZoneAwareLocaleContext timeZoneAwareLocaleContext = (TimeZoneAwareLocaleContext)localeContext;
                timeZone = timeZoneAwareLocaleContext.getTimeZone();
            }
        }
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)this.localeAttributeName, (Object)locale);
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)this.timeZoneAttributeName, timeZone);
    }
}

