/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.cors.PreFlightRequestHandler;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.PathPatternMatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.pattern.PathPatternParser;

@Deprecated(since="7.0", forRemoval=true)
public class HandlerMappingIntrospector
implements CorsConfigurationSource,
PreFlightRequestHandler,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog((String)HandlerMappingIntrospector.class.getName());
    private static final String CACHED_RESULT_ATTRIBUTE = HandlerMappingIntrospector.class.getName() + ".CachedResult";
    private @Nullable ApplicationContext applicationContext;
    private @Nullable List<HandlerMapping> handlerMappings;
    private Map<HandlerMapping, PathPatternMatchableHandlerMapping> pathPatternMappings = Collections.emptyMap();
    private final CacheResultLogHelper cacheLogHelper = new CacheResultLogHelper();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        if (this.handlerMappings == null) {
            Assert.notNull((Object)this.applicationContext, (String)"No ApplicationContext");
            this.handlerMappings = HandlerMappingIntrospector.initHandlerMappings(this.applicationContext);
            this.pathPatternMappings = this.handlerMappings.stream().filter(m -> {
                MatchableHandlerMapping hm;
                return m instanceof MatchableHandlerMapping && (hm = (MatchableHandlerMapping)m).getPatternParser() != null;
            }).map(mapping -> (MatchableHandlerMapping)mapping).collect(Collectors.toMap(mapping -> mapping, PathPatternMatchableHandlerMapping::new));
        }
    }

    private static List<HandlerMapping> initHandlerMappings(ApplicationContext context) {
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
        if (!beans.isEmpty()) {
            ArrayList mappings = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(mappings);
            return Collections.unmodifiableList(mappings);
        }
        return Collections.unmodifiableList(HandlerMappingIntrospector.initFallback(context));
    }

    private static List<HandlerMapping> initFallback(ApplicationContext applicationContext) {
        Properties properties;
        try {
            ClassPathResource resource = new ClassPathResource("DispatcherServlet.properties", DispatcherServlet.class);
            properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load DispatcherServlet.properties: " + ex.getMessage());
        }
        String value = properties.getProperty(HandlerMapping.class.getName());
        String[] names = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<HandlerMapping> result = new ArrayList<HandlerMapping>(names.length);
        for (String name : names) {
            try {
                Class clazz = ClassUtils.forName((String)name, (ClassLoader)DispatcherServlet.class.getClassLoader());
                Object mapping = applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
                result.add((HandlerMapping)mapping);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Could not find default HandlerMapping [" + name + "]");
            }
        }
        return result;
    }

    public List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings != null ? this.handlerMappings : Collections.emptyList();
    }

    public boolean allHandlerMappingsUsePathPatternParser() {
        Assert.state((this.handlerMappings != null ? 1 : 0) != 0, (String)"Not yet initialized via afterPropertiesSet.");
        return this.getHandlerMappings().stream().allMatch(HandlerMapping::usesPathPatterns);
    }

    public void handlePreFlight(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Assert.state((this.handlerMappings != null ? 1 : 0) != 0, (String)"Not yet initialized via afterPropertiesSet.");
        Assert.state((boolean)CorsUtils.isPreFlightRequest((HttpServletRequest)request), (String)"Not a pre-flight request.");
        RequestPath previousPath = (RequestPath)request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
        try {
            ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
            for (HandlerMapping mapping : this.handlerMappings) {
                HandlerExecutionChain chain = mapping.getHandler(request);
                if (chain == null) continue;
                Object handler = chain.getHandler();
                if (handler instanceof PreFlightRequestHandler) {
                    PreFlightRequestHandler preFlightHandler = (PreFlightRequestHandler)handler;
                    preFlightHandler.handlePreFlight(request, response);
                    return;
                }
                throw new IllegalStateException("Expected PreFlightRequestHandler: " + String.valueOf(handler.getClass()));
            }
            throw new NoHandlerFoundException(request.getMethod(), request.getRequestURI(), new ServletServerHttpRequest(request).getHeaders());
        }
        finally {
            ServletRequestPathUtils.setParsedRequestPath((RequestPath)previousPath, (ServletRequest)request);
        }
    }

    public Filter createCacheFilter() {
        return (request, response, chain) -> {
            CachedResult previous = this.setCache((HttpServletRequest)request);
            try {
                chain.doFilter(request, response);
            }
            finally {
                this.resetCache(request, previous);
            }
        };
    }

    public @Nullable CachedResult setCache(HttpServletRequest request) {
        CachedResult previous = (CachedResult)request.getAttribute(CACHED_RESULT_ATTRIBUTE);
        if (previous == null || !previous.matches(request)) {
            CachedResult result;
            AttributesPreservingRequest wrapped = new AttributesPreservingRequest(request);
            try {
                result = this.doWithHandlerMapping((HttpServletRequest)wrapped, false, (arg_0, arg_1) -> this.lambda$setCache$4((HttpServletRequest)wrapped, request, arg_0, arg_1));
            }
            catch (Exception ex) {
                try {
                    AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
                    result = this.doWithHandlerMapping((HttpServletRequest)requestToUse, true, (arg_0, arg_1) -> HandlerMappingIntrospector.lambda$setCache$5((HttpServletRequest)wrapped, request, ex, arg_0, arg_1));
                }
                catch (Exception ex2) {
                    result = new CachedResult(request, null, null, ex, new IllegalStateException(ex2));
                }
            }
            if (result == null) {
                result = new CachedResult(request, null, null, null, null);
            }
            request.setAttribute(CACHED_RESULT_ATTRIBUTE, (Object)result);
        }
        return previous;
    }

    public void resetCache(ServletRequest request, @Nullable CachedResult cachedResult) {
        request.setAttribute(CACHED_RESULT_ATTRIBUTE, (Object)cachedResult);
    }

    public @Nullable MatchableHandlerMapping getMatchableHandlerMapping(HttpServletRequest request) throws Exception {
        CachedResult result = CachedResult.getResultFor(request);
        if (result != null) {
            return result.getHandlerMapping();
        }
        this.cacheLogHelper.logHandlerMappingCacheMiss(request);
        AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
        return this.doWithHandlerMapping((HttpServletRequest)requestToUse, false, (arg_0, arg_1) -> this.lambda$getMatchableHandlerMapping$6((HttpServletRequest)requestToUse, arg_0, arg_1));
    }

    private MatchableHandlerMapping createMatchableHandlerMapping(HandlerMapping mapping, HttpServletRequest request) {
        if (mapping instanceof MatchableHandlerMapping) {
            PathPatternMatchableHandlerMapping pathPatternMapping = this.pathPatternMappings.get(mapping);
            if (pathPatternMapping != null) {
                RequestPath requestPath = ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request);
                return new LookupPathMatchableHandlerMapping(pathPatternMapping, requestPath);
            }
            String lookupPath = (String)request.getAttribute(UrlPathHelper.PATH_ATTRIBUTE);
            return new LookupPathMatchableHandlerMapping((MatchableHandlerMapping)mapping, lookupPath);
        }
        throw new IllegalStateException("HandlerMapping is not a MatchableHandlerMapping");
    }

    public @Nullable CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        CachedResult result = CachedResult.getResultFor(request);
        if (result != null) {
            return result.getCorsConfig();
        }
        this.cacheLogHelper.logCorsConfigCacheMiss(request);
        try {
            boolean ignoreException = true;
            AttributesPreservingRequest requestToUse = new AttributesPreservingRequest(request);
            return this.doWithHandlerMapping((HttpServletRequest)requestToUse, ignoreException, (handlerMapping, executionChain) -> HandlerMappingIntrospector.getCorsConfiguration(executionChain, (HttpServletRequest)requestToUse));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static @Nullable CorsConfiguration getCorsConfiguration(HandlerExecutionChain chain, HttpServletRequest request) {
        for (HandlerInterceptor interceptor : chain.getInterceptorList()) {
            if (!(interceptor instanceof CorsConfigurationSource)) continue;
            CorsConfigurationSource source = (CorsConfigurationSource)interceptor;
            return source.getCorsConfiguration(request);
        }
        Object object = chain.getHandler();
        if (object instanceof CorsConfigurationSource) {
            CorsConfigurationSource source = (CorsConfigurationSource)object;
            return source.getCorsConfiguration(request);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> @Nullable T doWithHandlerMapping(HttpServletRequest request, boolean ignoreException, BiFunction<HandlerMapping, HandlerExecutionChain, T> extractor) throws Exception {
        Assert.state((this.handlerMappings != null ? 1 : 0) != 0, (String)"HandlerMapping's not initialized");
        boolean parsePath = !this.pathPatternMappings.isEmpty();
        RequestPath previousPath = null;
        if (parsePath) {
            previousPath = (RequestPath)request.getAttribute(ServletRequestPathUtils.PATH_ATTRIBUTE);
            ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
        }
        try {
            for (HandlerMapping handlerMapping : this.handlerMappings) {
                HandlerExecutionChain chain;
                block8: {
                    chain = null;
                    try {
                        chain = handlerMapping.getHandler(request);
                    }
                    catch (Exception ex) {
                        if (ignoreException) break block8;
                        throw ex;
                    }
                }
                if (chain == null) continue;
                T t = extractor.apply(handlerMapping, chain);
                return t;
            }
        }
        finally {
            if (parsePath) {
                ServletRequestPathUtils.setParsedRequestPath((RequestPath)previousPath, (ServletRequest)request);
            }
        }
        return null;
    }

    private /* synthetic */ MatchableHandlerMapping lambda$getMatchableHandlerMapping$6(HttpServletRequest requestToUse, HandlerMapping mapping, HandlerExecutionChain executionChain) {
        return this.createMatchableHandlerMapping(mapping, requestToUse);
    }

    private static /* synthetic */ CachedResult lambda$setCache$5(HttpServletRequest wrapped, HttpServletRequest request, Exception ex, HandlerMapping mapping, HandlerExecutionChain executionChain) {
        CorsConfiguration corsConfig = HandlerMappingIntrospector.getCorsConfiguration(executionChain, wrapped);
        return new CachedResult(request, null, corsConfig, ex, null);
    }

    private /* synthetic */ CachedResult lambda$setCache$4(HttpServletRequest wrapped, HttpServletRequest request, HandlerMapping mapping, HandlerExecutionChain executionChain) {
        MatchableHandlerMapping matchableMapping = this.createMatchableHandlerMapping(mapping, wrapped);
        CorsConfiguration corsConfig = HandlerMappingIntrospector.getCorsConfiguration(executionChain, wrapped);
        return new CachedResult(request, matchableMapping, corsConfig, null, null);
    }

    private static class CacheResultLogHelper {
        private final Map<String, AtomicInteger> counters = Map.of("MatchableHandlerMapping", new AtomicInteger(), "CorsConfiguration", new AtomicInteger());

        private CacheResultLogHelper() {
        }

        public void logHandlerMappingCacheMiss(HttpServletRequest request) {
            this.logCacheMiss("MatchableHandlerMapping", request);
        }

        public void logCorsConfigCacheMiss(HttpServletRequest request) {
            this.logCacheMiss("CorsConfiguration", request);
        }

        private void logCacheMiss(String label, HttpServletRequest request) {
            AtomicInteger counter = this.counters.get(label);
            Assert.notNull((Object)counter, (String)("Expected '" + label + "' counter."));
            String message = CacheResultLogHelper.getLogMessage(label, request);
            if (logger.isWarnEnabled() && counter.getAndIncrement() == 0) {
                logger.warn((Object)(message + " This is logged once only at WARN level, and every time at TRACE."));
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("No CachedResult, performing " + label + " lookup instead."));
            }
        }

        private static String getLogMessage(String label, HttpServletRequest request) {
            return "Cache miss for " + String.valueOf(request.getDispatcherType()) + " dispatch to '" + request.getRequestURI() + "' (previous " + String.valueOf(request.getAttribute(CACHED_RESULT_ATTRIBUTE)) + "). Performing " + label + " lookup.";
        }
    }

    public static final class CachedResult {
        private final DispatcherType dispatcherType;
        private final String requestURI;
        private final @Nullable MatchableHandlerMapping handlerMapping;
        private final @Nullable CorsConfiguration corsConfig;
        private final @Nullable Exception failure;
        private final @Nullable IllegalStateException corsConfigFailure;

        private CachedResult(HttpServletRequest request, @Nullable MatchableHandlerMapping mapping, @Nullable CorsConfiguration config, @Nullable Exception failure, @Nullable IllegalStateException corsConfigFailure) {
            this.dispatcherType = request.getDispatcherType();
            this.requestURI = request.getRequestURI();
            this.handlerMapping = mapping;
            this.corsConfig = config;
            this.failure = failure;
            this.corsConfigFailure = corsConfigFailure;
        }

        public boolean matches(HttpServletRequest request) {
            return this.dispatcherType.equals((Object)request.getDispatcherType()) && this.requestURI.equals(request.getRequestURI());
        }

        public @Nullable MatchableHandlerMapping getHandlerMapping() throws Exception {
            if (this.failure != null) {
                throw this.failure;
            }
            return this.handlerMapping;
        }

        public @Nullable CorsConfiguration getCorsConfig() {
            if (this.corsConfigFailure != null) {
                throw this.corsConfigFailure;
            }
            return this.corsConfig;
        }

        public String toString() {
            return "CachedResult for " + String.valueOf(this.dispatcherType) + " dispatch to '" + this.requestURI + "'";
        }

        public static @Nullable CachedResult getResultFor(HttpServletRequest request) {
            CachedResult result = (CachedResult)request.getAttribute(CACHED_RESULT_ATTRIBUTE);
            return result != null && result.matches(request) ? result : null;
        }
    }

    private static class AttributesPreservingRequest
    extends HttpServletRequestWrapper {
        private final Map<String, Object> attributes;

        AttributesPreservingRequest(HttpServletRequest request) {
            super(request);
            this.attributes = this.initAttributes(request);
            this.attributes.put(AbstractHandlerMapping.SUPPRESS_LOGGING_ATTRIBUTE, Boolean.TRUE);
        }

        private Map<String, Object> initAttributes(HttpServletRequest request) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                map.put(name, request.getAttribute(name));
            }
            return map;
        }

        public void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        public @Nullable Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }
    }

    private static class LookupPathMatchableHandlerMapping
    implements MatchableHandlerMapping {
        private final MatchableHandlerMapping delegate;
        private final Object lookupPath;
        private final String pathAttributeName;

        LookupPathMatchableHandlerMapping(MatchableHandlerMapping delegate, Object lookupPath) {
            this.delegate = delegate;
            this.lookupPath = lookupPath;
            this.pathAttributeName = lookupPath instanceof RequestPath ? ServletRequestPathUtils.PATH_ATTRIBUTE : UrlPathHelper.PATH_ATTRIBUTE;
        }

        @Override
        public @Nullable PathPatternParser getPatternParser() {
            return this.delegate.getPatternParser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated(since="7.0", forRemoval=true)
        public @Nullable RequestMatchResult match(HttpServletRequest request, String pattern) {
            pattern = this.initFullPathPattern(pattern);
            Object previousPath = request.getAttribute(this.pathAttributeName);
            request.setAttribute(this.pathAttributeName, this.lookupPath);
            try {
                RequestMatchResult requestMatchResult = this.delegate.match(request, pattern);
                return requestMatchResult;
            }
            finally {
                request.setAttribute(this.pathAttributeName, previousPath);
            }
        }

        private String initFullPathPattern(String pattern) {
            PathPatternParser parser = this.getPatternParser() != null ? this.getPatternParser() : PathPatternParser.defaultInstance;
            return parser.initFullPathPattern(pattern);
        }

        @Override
        public @Nullable HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
            return this.delegate.getHandler(request);
        }
    }
}

