/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactory;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfig;

public class FreeMarkerConfigurer
extends FreeMarkerConfigurationFactory
implements FreeMarkerConfig,
InitializingBean,
ResourceLoaderAware {
    private @Nullable Configuration configuration;

    public FreeMarkerConfigurer() {
        this.setDefaultCharset(StandardCharsets.UTF_8);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws IOException, TemplateException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    protected void postProcessTemplateLoaders(List<TemplateLoader> templateLoaders) {
        templateLoaders.add((TemplateLoader)new ClassTemplateLoader(FreeMarkerConfigurer.class, ""));
    }

    @Override
    public Configuration getConfiguration() {
        Assert.state((this.configuration != null ? 1 : 0) != 0, (String)"No Configuration available");
        return this.configuration;
    }
}

