/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ExtendedWebExchangeDataBinder;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;

class InitBinderBindingContext
extends BindingContext {
    private final List<SyncInvocableHandlerMethod> binderMethods;
    private final BindingContext binderMethodContext;
    private final SessionStatus sessionStatus = new SimpleSessionStatus();
    private @Nullable Runnable saveModelOperation;

    InitBinderBindingContext(@Nullable WebBindingInitializer initializer, List<SyncInvocableHandlerMethod> binderMethods, boolean methodValidationApplicable, ReactiveAdapterRegistry registry) {
        super(initializer, registry);
        this.binderMethods = binderMethods;
        this.binderMethodContext = new BindingContext(initializer, registry);
        this.setMethodValidationApplicable(methodValidationApplicable);
    }

    public SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    @Override
    protected WebExchangeDataBinder createBinderInstance(@Nullable Object target, String name) {
        return new ExtendedWebExchangeDataBinder(target, name);
    }

    @Override
    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder dataBinder, ServerWebExchange exchange2) {
        this.binderMethods.stream().filter(binderMethod -> {
            InitBinder ann = (InitBinder)binderMethod.getMethodAnnotation(InitBinder.class);
            Assert.state((ann != null ? 1 : 0) != 0, (String)"No InitBinder annotation");
            Object[] names = ann.value();
            return ObjectUtils.isEmpty((Object[])names) || ObjectUtils.containsElement((Object[])names, (Object)dataBinder.getObjectName());
        }).forEach(method -> this.invokeBinderMethod(dataBinder, exchange2, (SyncInvocableHandlerMethod)((Object)method)));
        return dataBinder;
    }

    private void invokeBinderMethod(WebExchangeDataBinder dataBinder, ServerWebExchange exchange2, SyncInvocableHandlerMethod binderMethod) {
        HandlerResult result = binderMethod.invokeForHandlerResult(exchange2, this.binderMethodContext, dataBinder);
        if (result != null && result.getReturnValue() != null) {
            throw new IllegalStateException("@InitBinder methods must not return a value (should be void): " + String.valueOf((Object)binderMethod));
        }
        if (!this.binderMethodContext.getModel().asMap().isEmpty()) {
            throw new IllegalStateException("@InitBinder methods are not allowed to add model attributes: " + String.valueOf((Object)binderMethod));
        }
    }

    public void setSessionContext(SessionAttributesHandler attributesHandler, WebSession session) {
        this.saveModelOperation = () -> {
            if (this.getSessionStatus().isComplete()) {
                attributesHandler.cleanupAttributes(session);
            } else {
                attributesHandler.storeAttributes(session, this.getModel().asMap());
            }
        };
    }

    @Override
    public void updateModel(ServerWebExchange exchange2) {
        if (this.saveModelOperation != null) {
            this.saveModelOperation.run();
        }
        super.updateModel(exchange2);
    }
}

