/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client.support;

import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.invoker.ReactorHttpExchangeAdapterDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NotFoundWebClientAdapterDecorator
extends ReactorHttpExchangeAdapterDecorator {
    public NotFoundWebClientAdapterDecorator(HttpExchangeAdapter delegate) {
        super(delegate);
    }

    public <T> @Nullable T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        try {
            return (T)super.exchangeForBody(values, bodyType);
        }
        catch (WebClientResponseException.NotFound ex) {
            return null;
        }
    }

    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        try {
            return super.exchangeForBodilessEntity(values);
        }
        catch (WebClientResponseException.NotFound ex) {
            return ResponseEntity.notFound().build();
        }
    }

    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        try {
            return super.exchangeForEntity(values, bodyType);
        }
        catch (WebClientResponseException.NotFound ex) {
            return ResponseEntity.notFound().build();
        }
    }

    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return super.exchangeForBodyMono(values, bodyType).onErrorResume(WebClientResponseException.NotFound.class, ex -> Mono.empty());
    }

    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return super.exchangeForBodyFlux(values, bodyType).onErrorResume(WebClientResponseException.NotFound.class, ex -> Flux.empty());
    }

    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues values) {
        return super.exchangeForBodilessEntityMono(values).onErrorResume(WebClientResponseException.NotFound.class, ex -> Mono.just((Object)ResponseEntity.notFound().build()));
    }

    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return super.exchangeForEntityMono(values, bodyType).onErrorResume(WebClientResponseException.NotFound.class, ex -> Mono.just((Object)ResponseEntity.notFound().build()));
    }

    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return super.exchangeForEntityFlux(values, bodyType).onErrorResume(WebClientResponseException.NotFound.class, ex -> Mono.just((Object)ResponseEntity.notFound().build()));
    }
}

