/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultResourceResolverChain
implements ResourceResolverChain {
    private final @Nullable ResourceResolver resolver;
    private final @Nullable ResourceResolverChain nextChain;

    public DefaultResourceResolverChain(@Nullable List<? extends ResourceResolver> resolvers) {
        resolvers = resolvers != null ? resolvers : Collections.emptyList();
        DefaultResourceResolverChain chain = DefaultResourceResolverChain.initChain(new ArrayList<ResourceResolver>(resolvers));
        this.resolver = chain.resolver;
        this.nextChain = chain.nextChain;
    }

    private static DefaultResourceResolverChain initChain(ArrayList<? extends ResourceResolver> resolvers) {
        DefaultResourceResolverChain chain = new DefaultResourceResolverChain(null, null);
        ListIterator<? extends ResourceResolver> it = resolvers.listIterator(resolvers.size());
        while (it.hasPrevious()) {
            chain = new DefaultResourceResolverChain(it.previous(), chain);
        }
        return chain;
    }

    private DefaultResourceResolverChain(@Nullable ResourceResolver resolver, @Nullable ResourceResolverChain chain) {
        Assert.isTrue((resolver == null && chain == null || resolver != null && chain != null ? 1 : 0) != 0, (String)"Both resolver and resolver chain must be null, or neither is");
        this.resolver = resolver;
        this.nextChain = chain;
    }

    @Override
    public Mono<Resource> resolveResource(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations) {
        return this.resolver != null && this.nextChain != null ? this.resolver.resolveResource(exchange2, requestPath, locations, this.nextChain) : Mono.empty();
    }

    @Override
    public Mono<String> resolveUrlPath(String resourcePath, List<? extends Resource> locations) {
        return this.resolver != null && this.nextChain != null ? this.resolver.resolveUrlPath(resourcePath, locations, this.nextChain) : Mono.empty();
    }
}

