/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultServerRequestBuilder
implements ServerRequest.Builder {
    private final List<HttpMessageReader<?>> messageReaders;
    private final ServerWebExchange exchange;
    private HttpMethod method;
    private URI uri;
    private @Nullable String contextPath;
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private Flux<DataBuffer> body = Flux.empty();

    DefaultServerRequestBuilder(ServerRequest other) {
        Assert.notNull((Object)other, (String)"ServerRequest must not be null");
        this.messageReaders = other.messageReaders();
        this.exchange = other.exchange();
        this.method = other.method();
        this.uri = other.uri();
        this.contextPath = other.requestPath().contextPath().value();
        this.headers.addAll(other.headers().asHttpHeaders());
        this.cookies.addAll(other.cookies());
        this.attributes.putAll(other.attributes());
    }

    @Override
    public ServerRequest.Builder method(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null");
        this.method = method;
        return this;
    }

    @Override
    public ServerRequest.Builder uri(URI uri) {
        Assert.notNull((Object)uri, (String)"URI must not be null");
        this.uri = uri;
        return this;
    }

    @Override
    public ServerRequest.Builder contextPath(@Nullable String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Override
    public ServerRequest.Builder header(String headerName, String ... headerValues) {
        Assert.notNull((Object)headerName, (String)"Header name must not be null");
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ServerRequest.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        Assert.notNull(headersConsumer, (String)"Headers consumer must not be null");
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ServerRequest.Builder cookie(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Cookie name must not be null");
        for (String value : values) {
            this.cookies.add((Object)name, (Object)new HttpCookie(name, value));
        }
        return this;
    }

    @Override
    public ServerRequest.Builder cookies(Consumer<MultiValueMap<String, HttpCookie>> cookiesConsumer) {
        Assert.notNull(cookiesConsumer, (String)"Cookies consumer must not be null");
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ServerRequest.Builder body(Flux<DataBuffer> body2) {
        Assert.notNull(body2, (String)"Body must not be null");
        this.releaseBody();
        this.body = body2;
        return this;
    }

    @Override
    public ServerRequest.Builder body(String body2) {
        Assert.notNull((Object)body2, (String)"Body must not be null");
        this.releaseBody();
        this.body = Flux.just((Object)body2).map(s -> {
            byte[] bytes = body2.getBytes(StandardCharsets.UTF_8);
            return DefaultDataBufferFactory.sharedInstance.wrap(bytes);
        });
        return this;
    }

    private void releaseBody() {
        this.body.subscribe(DataBufferUtils.releaseConsumer());
    }

    @Override
    public ServerRequest.Builder attribute(String name, Object value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public ServerRequest.Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
        Assert.notNull(attributesConsumer, (String)"Attributes consumer must not be null");
        attributesConsumer.accept(this.attributes);
        return this;
    }

    @Override
    public ServerRequest build() {
        BuiltServerHttpRequest serverHttpRequest = new BuiltServerHttpRequest(this.exchange.getRequest().getId(), this.method, this.uri, this.contextPath, this.headers, this.cookies, this.body, this.attributes);
        DelegatingServerWebExchange exchange2 = new DelegatingServerWebExchange(serverHttpRequest, this.attributes, this.exchange, this.messageReaders);
        return new DefaultServerRequest(exchange2, this.messageReaders);
    }

    private static class BuiltServerHttpRequest
    implements ServerHttpRequest {
        private static final Pattern QUERY_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
        private final String id;
        private final HttpMethod method;
        private final URI uri;
        private final RequestPath path;
        private final MultiValueMap<String, String> queryParams;
        private final HttpHeaders headers;
        private final MultiValueMap<String, HttpCookie> cookies;
        private final Flux<DataBuffer> body;
        private final Map<String, Object> attributes;

        public BuiltServerHttpRequest(String id, HttpMethod method, URI uri, @Nullable String contextPath, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, Flux<DataBuffer> body2, Map<String, Object> attributes) {
            this.id = id;
            this.method = method;
            this.uri = uri;
            this.path = RequestPath.parse((URI)uri, (String)contextPath);
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers);
            this.cookies = BuiltServerHttpRequest.unmodifiableCopy(cookies);
            this.queryParams = BuiltServerHttpRequest.parseQueryParams(uri);
            this.body = body2;
            this.attributes = attributes;
        }

        private static <K, V> MultiValueMap<K, V> unmodifiableCopy(MultiValueMap<K, V> original) {
            return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(original));
        }

        private static MultiValueMap<String, String> parseQueryParams(URI uri) {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            String query = uri.getRawQuery();
            if (query != null) {
                Matcher matcher = QUERY_PATTERN.matcher(query);
                while (matcher.find()) {
                    String name = UriUtils.decode((String)matcher.group(1), (Charset)StandardCharsets.UTF_8);
                    String eq = matcher.group(2);
                    String value = matcher.group(3);
                    value = value != null ? UriUtils.decode((String)value, (Charset)StandardCharsets.UTF_8) : (StringUtils.hasLength((String)eq) ? "" : null);
                    queryParams.add((Object)name, (Object)value);
                }
            }
            return queryParams;
        }

        public String getId() {
            return this.id;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public URI getURI() {
            return this.uri;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public RequestPath getPath() {
            return this.path;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public MultiValueMap<String, HttpCookie> getCookies() {
            return this.cookies;
        }

        public MultiValueMap<String, String> getQueryParams() {
            return this.queryParams;
        }

        public Flux<DataBuffer> getBody() {
            return this.body;
        }
    }

    private static class DelegatingServerWebExchange
    implements ServerWebExchange {
        private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
        private static final ResolvableType MULTIPART_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Part.class});
        private static final Mono<MultiValueMap<String, String>> EMPTY_FORM_DATA = Mono.just((Object)CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(0))).cache();
        private static final Mono<MultiValueMap<String, Part>> EMPTY_MULTIPART_DATA = Mono.just((Object)CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(0))).cache();
        private final ServerHttpRequest request;
        private final Map<String, Object> attributes;
        private final ServerWebExchange delegate;
        private final Mono<MultiValueMap<String, String>> formDataMono;
        private final Mono<MultiValueMap<String, Part>> multipartDataMono;

        DelegatingServerWebExchange(ServerHttpRequest request, Map<String, Object> attributes, ServerWebExchange delegate, List<HttpMessageReader<?>> messageReaders) {
            this.request = request;
            this.attributes = attributes;
            this.delegate = delegate;
            this.formDataMono = DelegatingServerWebExchange.initFormData(request, messageReaders);
            this.multipartDataMono = DelegatingServerWebExchange.initMultipartData(request, messageReaders);
        }

        private static Mono<MultiValueMap<String, String>> initFormData(ServerHttpRequest request, List<HttpMessageReader<?>> readers) {
            try {
                MediaType contentType = request.getHeaders().getContentType();
                if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType)) {
                    return readers.stream().filter(reader -> reader.canRead(FORM_DATA_TYPE, MediaType.APPLICATION_FORM_URLENCODED)).findFirst().orElseThrow(() -> new IllegalStateException("No form data HttpMessageReader.")).readMono(FORM_DATA_TYPE, (ReactiveHttpInputMessage)request, Hints.none()).switchIfEmpty(EMPTY_FORM_DATA).cache();
                }
            }
            catch (InvalidMediaTypeException invalidMediaTypeException) {
                // empty catch block
            }
            return EMPTY_FORM_DATA;
        }

        private static Mono<MultiValueMap<String, Part>> initMultipartData(ServerHttpRequest request, List<HttpMessageReader<?>> readers) {
            try {
                MediaType contentType = request.getHeaders().getContentType();
                if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
                    return readers.stream().filter(reader -> reader.canRead(MULTIPART_DATA_TYPE, MediaType.MULTIPART_FORM_DATA)).findFirst().orElseThrow(() -> new IllegalStateException("No multipart HttpMessageReader.")).readMono(MULTIPART_DATA_TYPE, (ReactiveHttpInputMessage)request, Hints.none()).switchIfEmpty(EMPTY_MULTIPART_DATA).cache();
                }
            }
            catch (InvalidMediaTypeException invalidMediaTypeException) {
                // empty catch block
            }
            return EMPTY_MULTIPART_DATA;
        }

        public ServerHttpRequest getRequest() {
            return this.request;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Mono<MultiValueMap<String, String>> getFormData() {
            return this.formDataMono;
        }

        public Mono<MultiValueMap<String, Part>> getMultipartData() {
            return this.multipartDataMono;
        }

        public ServerHttpResponse getResponse() {
            return this.delegate.getResponse();
        }

        public Mono<WebSession> getSession() {
            return this.delegate.getSession();
        }

        public <T extends Principal> Mono<T> getPrincipal() {
            return this.delegate.getPrincipal();
        }

        public LocaleContext getLocaleContext() {
            return this.delegate.getLocaleContext();
        }

        public @Nullable ApplicationContext getApplicationContext() {
            return this.delegate.getApplicationContext();
        }

        public boolean isNotModified() {
            return this.delegate.isNotModified();
        }

        public boolean checkNotModified(Instant lastModified) {
            return this.delegate.checkNotModified(lastModified);
        }

        public boolean checkNotModified(String etag) {
            return this.delegate.checkNotModified(etag);
        }

        public boolean checkNotModified(@Nullable String etag, Instant lastModified) {
            return this.delegate.checkNotModified(etag, lastModified);
        }

        public String transformUrl(String url) {
            return this.delegate.transformUrl(url);
        }

        public void addUrlTransformer(Function<String, String> transformer) {
            this.delegate.addUrlTransformer(transformer);
        }

        public String getLogPrefix() {
            return this.delegate.getLogPrefix();
        }
    }
}

