/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.SemanticApiVersionParser;
import org.springframework.web.reactive.accept.ApiVersionResolver;
import org.springframework.web.reactive.accept.ApiVersionStrategy;
import org.springframework.web.reactive.accept.DefaultApiVersionStrategy;
import org.springframework.web.reactive.accept.PathApiVersionResolver;

public class ApiVersionConfigurer {
    private final List<ApiVersionResolver> versionResolvers = new ArrayList<ApiVersionResolver>();
    private @Nullable ApiVersionParser<?> versionParser;
    private boolean versionRequired = true;
    private @Nullable String defaultVersion;
    private final Set<String> supportedVersions = new LinkedHashSet<String>();
    private boolean detectSupportedVersions = true;

    public ApiVersionConfigurer useRequestHeader(String headerName) {
        this.versionResolvers.add(exchange2 -> exchange2.getRequest().getHeaders().getFirst(headerName));
        return this;
    }

    public ApiVersionConfigurer useRequestParam(String paramName) {
        this.versionResolvers.add(exchange2 -> (String)exchange2.getRequest().getQueryParams().getFirst((Object)paramName));
        return this;
    }

    public ApiVersionConfigurer usePathSegment(int index) {
        this.versionResolvers.add(new PathApiVersionResolver(index));
        return this;
    }

    public ApiVersionConfigurer useVersionResolver(ApiVersionResolver ... resolvers) {
        this.versionResolvers.addAll(Arrays.asList(resolvers));
        return this;
    }

    public ApiVersionConfigurer setVersionParser(@Nullable ApiVersionParser<?> versionParser) {
        this.versionParser = versionParser;
        return this;
    }

    public ApiVersionConfigurer setVersionRequired(boolean required) {
        this.versionRequired = required;
        return this;
    }

    public ApiVersionConfigurer setDefaultVersion(@Nullable String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    public ApiVersionConfigurer addSupportedVersions(String ... versions) {
        Collections.addAll(this.supportedVersions, versions);
        return this;
    }

    public ApiVersionConfigurer detectSupportedVersions(boolean detect) {
        this.detectSupportedVersions = detect;
        return this;
    }

    protected @Nullable ApiVersionStrategy getApiVersionStrategy() {
        DefaultApiVersionStrategy strategy;
        if (this.versionResolvers.isEmpty()) {
            return null;
        }
        DefaultApiVersionStrategy defaultApiVersionStrategy = strategy = new DefaultApiVersionStrategy(this.versionResolvers, (ApiVersionParser<?>)(this.versionParser != null ? this.versionParser : new SemanticApiVersionParser()), this.versionRequired, this.defaultVersion, this.detectSupportedVersions);
        Objects.requireNonNull(defaultApiVersionStrategy);
        DefaultApiVersionStrategy defaultApiVersionStrategy2 = defaultApiVersionStrategy;
        this.supportedVersions.forEach(xva$0 -> defaultApiVersionStrategy2.addSupportedVersion((String)xva$0));
        return strategy;
    }
}

