/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.codec.Hints;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultClientResponse
implements ClientResponse {
    private final ClientHttpResponse response;
    private final ClientResponse.Headers headers;
    private final ExchangeStrategies strategies;
    private final String logPrefix;

    public DefaultClientResponse(ClientHttpResponse response, ExchangeStrategies strategies, String logPrefix) {
        this.response = response;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
        this.logPrefix = logPrefix;
    }

    @Override
    public ExchangeStrategies strategies() {
        return this.strategies;
    }

    @Override
    public HttpStatus statusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public int rawStatusCode() {
        return this.response.getRawStatusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> cookies() {
        return this.response.getCookies();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        return extractor.extract((ClientHttpResponse)this.response, new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return DefaultClientResponse.this.strategies.messageReaders();
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.empty();
            }

            @Override
            public Map<String, Object> hints() {
                return Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)DefaultClientResponse.this.logPrefix);
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toMono(elementClass));
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
        return this.body(BodyExtractors.toMono(typeReference));
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toFlux(elementClass));
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
        return this.body(BodyExtractors.toFlux(typeReference));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
        return this.toEntityInternal(this.bodyToMono(bodyType));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> typeReference) {
        return this.toEntityInternal(this.bodyToMono(typeReference));
    }

    private <T> Mono<ResponseEntity<T>> toEntityInternal(Mono<T> bodyMono) {
        HttpHeaders headers2 = this.headers().asHttpHeaders();
        int status = this.rawStatusCode();
        return bodyMono.map(body2 -> this.createEntity(body2, headers2, status)).switchIfEmpty(Mono.defer(() -> Mono.just(this.createEntity(headers2, status))));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> responseType) {
        return this.toEntityListInternal(this.bodyToFlux(responseType));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> typeReference) {
        return this.toEntityListInternal(this.bodyToFlux(typeReference));
    }

    private <T> Mono<ResponseEntity<List<T>>> toEntityListInternal(Flux<T> bodyFlux) {
        HttpHeaders headers2 = this.headers().asHttpHeaders();
        int status = this.rawStatusCode();
        return bodyFlux.collectList().map(body2 -> this.createEntity(body2, headers2, status));
    }

    private <T> ResponseEntity<T> createEntity(HttpHeaders headers2, int status) {
        HttpStatus resolvedStatus = HttpStatus.resolve((int)status);
        return resolvedStatus != null ? new ResponseEntity((MultiValueMap)headers2, resolvedStatus) : ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)status).headers(headers2)).build();
    }

    private <T> ResponseEntity<T> createEntity(T body2, HttpHeaders headers2, int status) {
        HttpStatus resolvedStatus = HttpStatus.resolve((int)status);
        return resolvedStatus != null ? new ResponseEntity(body2, (MultiValueMap)headers2, resolvedStatus) : ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)status).headers(headers2)).body(body2);
    }

    private class DefaultHeaders
    implements ClientResponse.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultClientResponse.this.response.getHeaders();
        }

        @Override
        public OptionalLong contentLength() {
            return this.toOptionalLong(this.delegate().getContentLength());
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }
}

