/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;

public final class RequestMethodsRequestCondition
extends AbstractRequestCondition<RequestMethodsRequestCondition> {
    private static final RequestMethodsRequestCondition HEAD_CONDITION = new RequestMethodsRequestCondition(RequestMethod.HEAD);
    private final Set<RequestMethod> methods;

    public RequestMethodsRequestCondition(RequestMethod ... requestMethods) {
        this(RequestMethodsRequestCondition.asList(requestMethods));
    }

    private RequestMethodsRequestCondition(Collection<RequestMethod> requestMethods) {
        this.methods = Collections.unmodifiableSet(new LinkedHashSet<RequestMethod>(requestMethods));
    }

    private static List<RequestMethod> asList(RequestMethod ... requestMethods) {
        return requestMethods != null ? Arrays.asList(requestMethods) : Collections.emptyList();
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    protected Collection<RequestMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        LinkedHashSet<RequestMethod> set = new LinkedHashSet<RequestMethod>(this.methods);
        set.addAll(other.methods);
        return new RequestMethodsRequestCondition(set);
    }

    @Override
    @Nullable
    public RequestMethodsRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
            return this.matchPreFlight(exchange.getRequest());
        }
        if (this.getMethods().isEmpty()) {
            if (RequestMethod.OPTIONS.name().equals(exchange.getRequest().getMethodValue())) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(exchange.getRequest().getMethod());
    }

    private RequestMethodsRequestCondition matchPreFlight(ServerHttpRequest request) {
        if (this.getMethods().isEmpty()) {
            return this;
        }
        HttpMethod expectedMethod = request.getHeaders().getAccessControlRequestMethod();
        return this.matchRequestMethod(expectedMethod);
    }

    @Nullable
    private RequestMethodsRequestCondition matchRequestMethod(@Nullable HttpMethod httpMethod) {
        if (httpMethod != null) {
            for (RequestMethod method2 : this.getMethods()) {
                if (!httpMethod.matches(method2.name())) continue;
                return new RequestMethodsRequestCondition(method2);
            }
            if (httpMethod == HttpMethod.HEAD && this.getMethods().contains(RequestMethod.GET)) {
                return HEAD_CONDITION;
            }
        }
        return null;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other, ServerWebExchange exchange) {
        return other.methods.size() - this.methods.size();
    }
}

