/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerResponseResultHandler
implements HandlerResultHandler,
InitializingBean,
Ordered {
    private List<HttpMessageWriter<?>> messageWriters = Collections.emptyList();
    private List<ViewResolver> viewResolvers = Collections.emptyList();
    private int order = Integer.MAX_VALUE;

    public void setMessageWriters(List<HttpMessageWriter<?>> configurer) {
        Assert.notNull(this.messageWriters, (String)"'messageWriters' must not be null");
        this.messageWriters = configurer;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.messageWriters)) {
            throw new IllegalArgumentException("Property 'messageWriters' is required");
        }
    }

    @Override
    public boolean supports(HandlerResult result) {
        return result.getReturnValue() instanceof ServerResponse;
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        ServerResponse response = (ServerResponse)result.getReturnValue();
        Assert.state((response != null ? 1 : 0) != 0, (String)"No ServerResponse");
        return response.writeTo(exchange, new ServerResponse.Context(){

            @Override
            public List<HttpMessageWriter<?>> messageWriters() {
                return ServerResponseResultHandler.this.messageWriters;
            }

            @Override
            public List<ViewResolver> viewResolvers() {
                return ServerResponseResultHandler.this.viewResolvers;
            }
        });
    }
}

