/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ApiVersionResolver;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class QueryApiVersionResolver
implements ApiVersionResolver {
    private final String queryParamName;

    public QueryApiVersionResolver(String queryParamName) {
        this.queryParamName = queryParamName;
    }

    @Override
    public @Nullable String resolveVersion(HttpServletRequest request) {
        String query = request.getQueryString();
        if (StringUtils.hasText((String)query)) {
            UriComponents uri = UriComponentsBuilder.fromUriString("?" + query).build();
            return (String)uri.getQueryParams().getFirst((Object)this.queryParamName);
        }
        return null;
    }
}

