/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;

public interface ApiVersionStrategy {
    public @Nullable String resolveVersion(HttpServletRequest var1);

    public Comparable<?> parseVersion(String var1);

    public void validateVersion(@Nullable Comparable<?> var1, HttpServletRequest var2) throws MissingApiVersionException, InvalidApiVersionException;

    public @Nullable Comparable<?> getDefaultVersion();

    default public @Nullable Comparable<?> resolveParseAndValidateVersion(HttpServletRequest request) {
        Comparable<?> version;
        String value = this.resolveVersion(request);
        if (value == null) {
            version = this.getDefaultVersion();
        } else {
            try {
                version = this.parseVersion(value);
            }
            catch (Exception ex) {
                throw new InvalidApiVersionException(value, null, ex);
            }
        }
        this.validateVersion(version, request);
        return version;
    }

    public void handleDeprecations(Comparable<?> var1, Object var2, HttpServletRequest var3, HttpServletResponse var4);
}

