/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import com.fasterxml.jackson.annotation.JsonView;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.converter.AbstractSmartHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJacksonInputMessage;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.TypeUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.util.DefaultIndenter;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.ser.FilterProvider;

public abstract class AbstractJacksonHttpMessageConverter
extends AbstractSmartHttpMessageConverter<Object> {
    private static final String JSON_VIEW_HINT = JsonView.class.getName();
    private static final String FILTER_PROVIDER_HINT = FilterProvider.class.getName();
    private static final Map<String, JsonEncoding> ENCODINGS;
    private static volatile @Nullable List<JacksonModule> modules;
    protected final ObjectMapper defaultObjectMapper;
    private @Nullable Map<Class<?>, Map<MediaType, ObjectMapper>> objectMapperRegistrations;
    private final @Nullable PrettyPrinter ssePrettyPrinter;

    private AbstractJacksonHttpMessageConverter(MapperBuilder<?, ?> builder) {
        this.defaultObjectMapper = builder.addModules(this.initModules()).build();
        this.ssePrettyPrinter = this.initSsePrettyPrinter();
    }

    protected AbstractJacksonHttpMessageConverter(MapperBuilder<?, ?> builder, MediaType supportedMediaType) {
        this(builder);
        this.setSupportedMediaTypes(Collections.singletonList(supportedMediaType));
    }

    protected AbstractJacksonHttpMessageConverter(MapperBuilder<?, ?> builder, MediaType ... supportedMediaTypes) {
        this(builder);
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    protected AbstractJacksonHttpMessageConverter(ObjectMapper objectMapper) {
        this.defaultObjectMapper = objectMapper;
        this.ssePrettyPrinter = this.initSsePrettyPrinter();
    }

    protected AbstractJacksonHttpMessageConverter(ObjectMapper objectMapper, MediaType supportedMediaType) {
        this(objectMapper);
        this.setSupportedMediaTypes(Collections.singletonList(supportedMediaType));
    }

    protected AbstractJacksonHttpMessageConverter(ObjectMapper objectMapper, MediaType ... supportedMediaTypes) {
        this(objectMapper);
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    private List<JacksonModule> initModules() {
        if (modules == null) {
            modules = MapperBuilder.findModules((ClassLoader)AbstractJacksonHttpMessageConverter.class.getClassLoader());
        }
        return Objects.requireNonNull(modules);
    }

    private PrettyPrinter initSsePrettyPrinter() {
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\ndata:"));
        return prettyPrinter;
    }

    @Override
    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        super.setSupportedMediaTypes(supportedMediaTypes);
    }

    public ObjectMapper getObjectMapper() {
        return this.defaultObjectMapper;
    }

    public void registerObjectMappersForType(Class<?> clazz, Consumer<Map<MediaType, ObjectMapper>> registrar) {
        if (this.objectMapperRegistrations == null) {
            this.objectMapperRegistrations = new LinkedHashMap();
        }
        Map registrations = this.objectMapperRegistrations.computeIfAbsent(clazz, c -> new LinkedHashMap());
        registrar.accept(registrations);
    }

    public Map<MediaType, ObjectMapper> getObjectMappersForType(Class<?> clazz) {
        for (Map.Entry<Class<?>, Map<MediaType, ObjectMapper>> entry : this.getObjectMapperRegistrations().entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        ArrayList<MediaType> result = null;
        for (Map.Entry<Class<?>, Map<MediaType, ObjectMapper>> entry : this.getObjectMapperRegistrations().entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            result = result != null ? result : new ArrayList<MediaType>(entry.getValue().size());
            result.addAll(entry.getValue().keySet());
        }
        if (!CollectionUtils.isEmpty(result)) {
            return result;
        }
        return ProblemDetail.class.isAssignableFrom(clazz) ? this.getMediaTypesForProblemDetail() : this.getSupportedMediaTypes();
    }

    private Map<Class<?>, Map<MediaType, ObjectMapper>> getObjectMapperRegistrations() {
        return this.objectMapperRegistrations != null ? this.objectMapperRegistrations : Collections.emptyMap();
    }

    protected List<MediaType> getMediaTypesForProblemDetail() {
        return Collections.emptyList();
    }

    @Override
    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        if (!this.canRead(mediaType)) {
            return false;
        }
        Class clazz = type.resolve();
        if (clazz == null) {
            return false;
        }
        return this.objectMapperRegistrations == null || this.selectObjectMapper(clazz, mediaType) != null;
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        Charset charset;
        if (!this.canWrite(mediaType)) {
            return false;
        }
        if (mediaType != null && mediaType.getCharset() != null && !ENCODINGS.containsKey((charset = mediaType.getCharset()).name())) {
            return false;
        }
        if (MappingJacksonValue.class.isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException("MappingJacksonValue is not supported, use hints instead");
        }
        return this.objectMapperRegistrations == null || this.selectObjectMapper(clazz, mediaType) != null;
    }

    private @Nullable ObjectMapper selectObjectMapper(Class<?> targetType, @Nullable MediaType targetMediaType) {
        if (targetMediaType == null || CollectionUtils.isEmpty(this.objectMapperRegistrations)) {
            return this.defaultObjectMapper;
        }
        for (Map.Entry<Class<?>, Map<MediaType, ObjectMapper>> typeEntry : this.getObjectMapperRegistrations().entrySet()) {
            if (!typeEntry.getKey().isAssignableFrom(targetType)) continue;
            for (Map.Entry<MediaType, ObjectMapper> objectMapperEntry : typeEntry.getValue().entrySet()) {
                if (!objectMapperEntry.getKey().includes(targetMediaType)) continue;
                return objectMapperEntry.getValue();
            }
            return null;
        }
        return this.defaultObjectMapper;
    }

    @Override
    public Object read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        Class clazz;
        Object object = type.getSource();
        if (object instanceof MethodParameter) {
            MethodParameter parameter = (MethodParameter)object;
            clazz = parameter.getContainingClass();
        } else {
            clazz = null;
        }
        Class contextClass = clazz;
        JavaType javaType = this.getJavaType(type.getType(), contextClass);
        return this.readJavaType(javaType, inputMessage, hints);
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz, null);
        return this.readJavaType(javaType, inputMessage, null);
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = this.getCharset(contentType);
        ObjectMapper objectMapper = this.selectObjectMapper(javaType.getRawClass(), contentType);
        Assert.state((objectMapper != null ? 1 : 0) != 0, () -> "No ObjectMapper for " + String.valueOf(javaType));
        boolean isUnicode = ENCODINGS.containsKey(charset.name()) || "UTF-16".equals(charset.name()) || "UTF-32".equals(charset.name());
        try {
            InputStream inputStream = StreamUtils.nonClosing((InputStream)inputMessage.getBody());
            if (inputMessage instanceof MappingJacksonInputMessage) {
                throw new UnsupportedOperationException("MappingJacksonInputMessage is not supported, use hints instead");
            }
            ObjectReader objectReader = objectMapper.readerFor(javaType);
            if (hints != null && hints.containsKey(JSON_VIEW_HINT)) {
                objectReader = objectReader.withView((Class)hints.get(JSON_VIEW_HINT));
            }
            objectReader = this.customizeReader(objectReader, javaType);
            if (isUnicode) {
                return objectReader.readValue(inputStream);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, charset);
            return objectReader.readValue((Reader)reader);
        }
        catch (InvalidDefinitionException ex) {
            throw new HttpMessageConversionException("Type definition error: " + String.valueOf(ex.getType()), ex);
        }
        catch (JacksonException ex) {
            throw new HttpMessageNotReadableException("JSON parse error: " + ex.getOriginalMessage(), ex, inputMessage);
        }
    }

    protected ObjectReader customizeReader(ObjectReader reader, JavaType javaType) {
        return reader;
    }

    protected Charset getCharset(@Nullable MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return contentType.getCharset();
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    protected void writeInternal(Object object, ResolvableType resolvableType, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        ObjectWriter objectWriter;
        MediaType contentType = outputMessage.getHeaders().getContentType();
        JsonEncoding encoding = this.getJsonEncoding(contentType);
        Class<?> clazz = object.getClass();
        ObjectMapper objectMapper = this.selectObjectMapper(clazz, contentType);
        Assert.state((objectMapper != null ? 1 : 0) != 0, () -> "No ObjectMapper for " + clazz.getName());
        OutputStream outputStream = StreamUtils.nonClosing((OutputStream)outputMessage.getBody());
        Class jsonView = null;
        FilterProvider filters = null;
        JavaType javaType = null;
        Type type = resolvableType.getType();
        if (TypeUtils.isAssignable((Type)type, object.getClass())) {
            javaType = this.getJavaType(type, null);
        }
        if (hints != null) {
            jsonView = (Class)hints.get(JSON_VIEW_HINT);
            filters = (FilterProvider)hints.get(FILTER_PROVIDER_HINT);
        }
        ObjectWriter objectWriter2 = objectWriter = jsonView != null ? objectMapper.writerWithView(jsonView) : objectMapper.writer();
        if (filters != null) {
            objectWriter = objectWriter.with(filters);
        }
        if (javaType != null && (javaType.isContainerType() || javaType.isTypeOrSubTypeOf(Optional.class))) {
            objectWriter = objectWriter.forType(javaType);
        }
        SerializationConfig config = objectWriter.getConfig();
        if (contentType != null && contentType.isCompatibleWith(MediaType.TEXT_EVENT_STREAM) && config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            objectWriter = objectWriter.with(this.ssePrettyPrinter);
        }
        objectWriter = this.customizeWriter(objectWriter, javaType, contentType);
        try (JsonGenerator generator = objectWriter.createGenerator(outputStream, encoding);){
            this.writePrefix(generator, object);
            objectWriter.writeValue(generator, object);
            this.writeSuffix(generator, object);
            generator.flush();
        }
        catch (InvalidDefinitionException ex) {
            throw new HttpMessageConversionException("Type definition error: " + String.valueOf(ex.getType()), ex);
        }
        catch (JacksonException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getOriginalMessage(), ex);
        }
    }

    protected ObjectWriter customizeWriter(ObjectWriter writer, @Nullable JavaType javaType, @Nullable MediaType contentType) {
        return writer;
    }

    protected void writePrefix(JsonGenerator generator, Object object) {
    }

    protected void writeSuffix(JsonGenerator generator, Object object) {
    }

    protected JavaType getJavaType(Type type, @Nullable Class<?> contextClass) {
        return this.defaultObjectMapper.constructType(GenericTypeResolver.resolveType((Type)type, contextClass));
    }

    protected JsonEncoding getJsonEncoding(@Nullable MediaType contentType) {
        Charset charset;
        JsonEncoding encoding;
        if (contentType != null && contentType.getCharset() != null && (encoding = ENCODINGS.get((charset = contentType.getCharset()).name())) != null) {
            return encoding;
        }
        return JsonEncoding.UTF8;
    }

    @Override
    protected boolean supportsRepeatableWrites(Object o) {
        return true;
    }

    static {
        modules = null;
        ENCODINGS = CollectionUtils.newHashMap((int)JsonEncoding.values().length);
        for (JsonEncoding encoding : JsonEncoding.values()) {
            ENCODINGS.put(encoding.getJavaName(), encoding);
        }
        ENCODINGS.put("US-ASCII", JsonEncoding.UTF8);
    }
}

