/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.util.UriComponentsBuilder;

public final class DefaultApiVersionInserter
implements ApiVersionInserter {
    private final @Nullable String header;
    private final @Nullable String queryParam;
    private final @Nullable Integer pathSegmentIndex;
    private final ApiVersionFormatter versionFormatter;

    private DefaultApiVersionInserter(@Nullable String header, @Nullable String queryParam, @Nullable Integer pathSegmentIndex, @Nullable ApiVersionFormatter formatter) {
        Assert.isTrue((header != null || queryParam != null || pathSegmentIndex != null ? 1 : 0) != 0, (String)"Expected 'header', 'queryParam', or 'pathSegmentIndex' to be configured");
        this.header = header;
        this.queryParam = queryParam;
        this.pathSegmentIndex = pathSegmentIndex;
        this.versionFormatter = formatter != null ? formatter : Object::toString;
    }

    @Override
    public URI insertVersion(Object version, URI uri) {
        if (this.queryParam == null && this.pathSegmentIndex == null) {
            return uri;
        }
        String formattedVersion = this.versionFormatter.formatVersion(version);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri(uri);
        if (this.queryParam != null) {
            builder.queryParam(this.queryParam, formattedVersion);
        }
        if (this.pathSegmentIndex != null) {
            ArrayList<String> pathSegments = new ArrayList<String>(builder.build().getPathSegments());
            this.assertPathSegmentIndex(this.pathSegmentIndex, pathSegments.size(), uri);
            pathSegments.add(this.pathSegmentIndex, formattedVersion);
            builder.replacePath(null);
            UriComponentsBuilder uriComponentsBuilder = builder;
            Objects.requireNonNull(uriComponentsBuilder);
            UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder;
            pathSegments.forEach(xva$0 -> uriComponentsBuilder2.pathSegment((String)xva$0));
        }
        return builder.build().toUri();
    }

    private void assertPathSegmentIndex(Integer index, int pathSegmentsSize, URI uri) {
        Assert.state((index <= pathSegmentsSize ? 1 : 0) != 0, (String)("Cannot insert version into '" + uri.getPath() + "' at path segment index " + index));
    }

    @Override
    public void insertVersion(Object version, HttpHeaders headers) {
        if (this.header != null) {
            headers.set(this.header, this.versionFormatter.formatVersion(version));
        }
    }

    public static Builder fromHeader(@Nullable String header) {
        return new Builder(header, null, null);
    }

    public static Builder fromQueryParam(@Nullable String queryParam) {
        return new Builder(null, queryParam, null);
    }

    public static Builder fromPathSegment(@Nullable Integer pathSegmentIndex) {
        return new Builder(null, null, pathSegmentIndex);
    }

    public static Builder builder() {
        return new Builder(null, null, null);
    }

    public static final class Builder {
        private @Nullable String header;
        private @Nullable String queryParam;
        private @Nullable Integer pathSegmentIndex;
        private @Nullable ApiVersionFormatter versionFormatter;

        private Builder(@Nullable String header, @Nullable String queryParam, @Nullable Integer pathSegmentIndex) {
            this.header = header;
            this.queryParam = queryParam;
            this.pathSegmentIndex = pathSegmentIndex;
        }

        public Builder fromHeader(@Nullable String header) {
            this.header = header;
            return this;
        }

        public Builder fromQueryParam(@Nullable String queryParam) {
            this.queryParam = queryParam;
            return this;
        }

        public Builder fromPathSegment(@Nullable Integer pathSegmentIndex) {
            this.pathSegmentIndex = pathSegmentIndex;
            return this;
        }

        public Builder withVersionFormatter(ApiVersionFormatter versionFormatter) {
            this.versionFormatter = versionFormatter;
            return this;
        }

        public ApiVersionInserter build() {
            return new DefaultApiVersionInserter(this.header, this.queryParam, this.pathSegmentIndex, this.versionFormatter);
        }
    }
}

