/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.ApiVersionResolver;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;

public class DefaultApiVersionStrategy
implements ApiVersionStrategy {
    private final List<ApiVersionResolver> versionResolvers;
    private final ApiVersionParser<?> versionParser;
    private final boolean versionRequired;
    private final @Nullable Comparable<?> defaultVersion;
    private final Set<Comparable<?>> supportedVersions = new TreeSet();

    public DefaultApiVersionStrategy(List<ApiVersionResolver> versionResolvers, ApiVersionParser<?> versionParser, boolean versionRequired, @Nullable String defaultVersion) {
        Assert.notEmpty(versionResolvers, (String)"At least one ApiVersionResolver is required");
        Assert.notNull(versionParser, (String)"ApiVersionParser is required");
        this.versionResolvers = new ArrayList<ApiVersionResolver>(versionResolvers);
        this.versionParser = versionParser;
        this.versionRequired = versionRequired && defaultVersion == null;
        this.defaultVersion = defaultVersion != null ? versionParser.parseVersion(defaultVersion) : null;
    }

    @Override
    public @Nullable Comparable<?> getDefaultVersion() {
        return this.defaultVersion;
    }

    public void addSupportedVersion(String ... versions) {
        for (String version : versions) {
            this.supportedVersions.add(this.parseVersion(version));
        }
    }

    @Override
    public @Nullable String resolveVersion(HttpServletRequest request) {
        for (ApiVersionResolver resolver : this.versionResolvers) {
            String version = resolver.resolveVersion(request);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Override
    public Comparable<?> parseVersion(String version) {
        return this.versionParser.parseVersion(version);
    }

    @Override
    public void validateVersion(@Nullable Comparable<?> requestVersion, HttpServletRequest request) throws MissingApiVersionException, InvalidApiVersionException {
        if (requestVersion == null) {
            if (this.versionRequired) {
                throw new MissingApiVersionException();
            }
            return;
        }
        if (!this.supportedVersions.contains(requestVersion)) {
            throw new InvalidApiVersionException(requestVersion.toString());
        }
    }

    public String toString() {
        return "DefaultApiVersionStrategy[supportedVersions=" + String.valueOf(this.supportedVersions) + ", versionRequired=" + this.versionRequired + ", defaultVersion=" + String.valueOf(this.defaultVersion) + "]";
    }
}

