/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.util.WebUtils;

public class FacesRequestAttributes
implements RequestAttributes {
    private static final Log logger = LogFactory.getLog((Class)FacesRequestAttributes.class);
    private final FacesContext facesContext;

    public FacesRequestAttributes(FacesContext facesContext) {
        Assert.notNull((Object)facesContext, (String)"FacesContext must not be null");
        this.facesContext = facesContext;
    }

    protected FacesContext getFacesContext() {
        return this.facesContext;
    }

    protected ExternalContext getExternalContext() {
        return this.getFacesContext().getExternalContext();
    }

    protected Map getAttributeMap(int scope) {
        if (scope == 0) {
            return this.getExternalContext().getRequestMap();
        }
        return this.getExternalContext().getSessionMap();
    }

    public Object getAttribute(String name, int scope) {
        return this.getAttributeMap(scope).get(name);
    }

    public void setAttribute(String name, Object value, int scope) {
        this.getAttributeMap(scope).put(name, value);
    }

    public void removeAttribute(String name, int scope) {
        this.getAttributeMap(scope).remove(name);
    }

    public String[] getAttributeNames(int scope) {
        return StringUtils.toStringArray(this.getAttributeMap(scope).keySet());
    }

    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Could not register destruction callback [" + callback + "] for attribute '" + name + "' because FacesRequestAttributes does not support such callbacks"));
        }
    }

    public String getSessionId() {
        Object session = this.getExternalContext().getSession(true);
        try {
            Method getIdMethod = session.getClass().getMethod("getId", new Class[0]);
            return ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)session).toString();
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Session object [" + session + "] does not have a getId() method");
        }
    }

    public Object getSessionMutex() {
        Object session = this.getExternalContext().getSession(true);
        Object mutex = this.getExternalContext().getSessionMap().get(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }
}

