/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.DispatcherType;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;

public abstract class MockMvcRequestBuilders {
    public static MockHttpServletRequestBuilder get(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.GET).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder get(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.GET).uri(uri);
    }

    public static MockHttpServletRequestBuilder post(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.POST).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder post(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.POST).uri(uri);
    }

    public static MockHttpServletRequestBuilder put(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.PUT).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder put(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.PUT).uri(uri);
    }

    public static MockHttpServletRequestBuilder patch(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.PATCH).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder patch(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.PATCH).uri(uri);
    }

    public static MockHttpServletRequestBuilder delete(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.DELETE).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder delete(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.DELETE).uri(uri);
    }

    public static MockHttpServletRequestBuilder options(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.OPTIONS).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder options(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.OPTIONS).uri(uri);
    }

    public static MockHttpServletRequestBuilder head(String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.HEAD).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder head(URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(HttpMethod.HEAD).uri(uri);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod method, String uriTemplate, Object ... uriVariables) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(method).uri(uriTemplate, uriVariables);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, URI uri) {
        return (MockHttpServletRequestBuilder)new MockHttpServletRequestBuilder(httpMethod).uri(uri);
    }

    @Deprecated(since="6.2")
    public static MockHttpServletRequestBuilder request(String httpMethod, URI uri) {
        return MockMvcRequestBuilders.request(HttpMethod.valueOf((String)httpMethod), uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(String uriTemplate, Object ... uriVariables) {
        return (MockMultipartHttpServletRequestBuilder)new MockMultipartHttpServletRequestBuilder().uri(uriTemplate, uriVariables);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, String uriTemplate, Object ... uriVariables) {
        return (MockMultipartHttpServletRequestBuilder)new MockMultipartHttpServletRequestBuilder(httpMethod).uri(uriTemplate, uriVariables);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(URI uri) {
        return (MockMultipartHttpServletRequestBuilder)new MockMultipartHttpServletRequestBuilder().uri(uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(HttpMethod httpMethod, URI uri) {
        return (MockMultipartHttpServletRequestBuilder)new MockMultipartHttpServletRequestBuilder(httpMethod).uri(uri);
    }

    public static RequestBuilder asyncDispatch(MvcResult mvcResult) {
        mvcResult.getAsyncResult();
        return servletContext -> {
            MockHttpServletRequest request = mvcResult.getRequest();
            request.setDispatcherType(DispatcherType.ASYNC);
            request.setAsyncStarted(false);
            return request;
        };
    }
}

