/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.security.cert.X509Certificate;
import org.jspecify.annotations.Nullable;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;

public final class UserWebTestClientConfigurer
implements WebTestClientConfigurer {
    private final SslInfo info;

    private UserWebTestClientConfigurer(SslInfo info) {
        this.info = info;
    }

    @Override
    public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder httpHandlerBuilder, @Nullable ClientHttpConnector connector) {
        Assert.state((httpHandlerBuilder != null ? 1 : 0) != 0, (String)"This configurer is applicable only to a mock WebFlux server");
        httpHandlerBuilder.filters(filters -> filters.add(0, new UserWebFilter()));
    }

    public static UserWebTestClientConfigurer x509(X509Certificate ... certificates) {
        return UserWebTestClientConfigurer.sslInfo(SslInfo.from((String)"1", (X509Certificate[])certificates));
    }

    public static UserWebTestClientConfigurer sslInfo(SslInfo info) {
        return new UserWebTestClientConfigurer(info);
    }

    private final class UserWebFilter
    implements WebFilter {
        private UserWebFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
            exchange = exchange.mutate().request(builder -> builder.sslInfo(UserWebTestClientConfigurer.this.info)).build();
            return chain.filter(exchange);
        }
    }
}

