/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.io.UnsupportedEncodingException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringStartsWith;
import org.jspecify.annotations.Nullable;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JsonPathResultMatchers {
    private final JsonPathExpectationsHelper jsonPathHelper;
    private @Nullable String prefix;

    protected JsonPathResultMatchers(String expression, Object ... args) {
        Assert.hasText((String)expression, (String)"expression must not be null or empty");
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression.formatted(args));
    }

    public JsonPathResultMatchers prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public <T> ResultMatcher value(Matcher<? super T> matcher) {
        return result -> this.jsonPathHelper.assertValue(this.getContent(result), matcher);
    }

    public <T> ResultMatcher value(Matcher<? super T> matcher, Class<T> targetType) {
        return result -> this.jsonPathHelper.assertValue(this.getContent(result), matcher, targetType);
    }

    public ResultMatcher value(@Nullable Object expectedValue) {
        return result -> this.jsonPathHelper.assertValue(this.getContent(result), expectedValue);
    }

    public ResultMatcher exists() {
        return result -> this.jsonPathHelper.exists(this.getContent(result));
    }

    public ResultMatcher doesNotExist() {
        return result -> this.jsonPathHelper.doesNotExist(this.getContent(result));
    }

    public ResultMatcher isEmpty() {
        return result -> this.jsonPathHelper.assertValueIsEmpty(this.getContent(result));
    }

    public ResultMatcher isNotEmpty() {
        return result -> this.jsonPathHelper.assertValueIsNotEmpty(this.getContent(result));
    }

    public ResultMatcher hasJsonPath() {
        return result -> this.jsonPathHelper.hasJsonPath(this.getContent(result));
    }

    public ResultMatcher doesNotHaveJsonPath() {
        return result -> this.jsonPathHelper.doesNotHaveJsonPath(this.getContent(result));
    }

    public ResultMatcher isString() {
        return result -> this.jsonPathHelper.assertValueIsString(this.getContent(result));
    }

    public ResultMatcher isBoolean() {
        return result -> this.jsonPathHelper.assertValueIsBoolean(this.getContent(result));
    }

    public ResultMatcher isNumber() {
        return result -> this.jsonPathHelper.assertValueIsNumber(this.getContent(result));
    }

    public ResultMatcher isArray() {
        return result -> this.jsonPathHelper.assertValueIsArray(this.getContent(result));
    }

    public ResultMatcher isMap() {
        return result -> this.jsonPathHelper.assertValueIsMap(this.getContent(result));
    }

    private String getContent(MvcResult result) throws UnsupportedEncodingException {
        String content = result.getResponse().getContentAsString();
        if (StringUtils.hasLength((String)this.prefix)) {
            try {
                String reason = String.format("Expected a JSON payload prefixed with \"%s\" but found: %s", this.prefix, StringUtils.quote((String)content.substring(0, this.prefix.length())));
                MatcherAssert.assertThat((String)reason, (Object)content, (Matcher)StringStartsWith.startsWith((String)this.prefix));
                return content.substring(this.prefix.length());
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new AssertionError("JSON prefix \"" + this.prefix + "\" not found", ex);
            }
        }
        return content;
    }
}

