/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import jakarta.servlet.http.Cookie;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.Assertions;

public class CookieMapAssert
extends AbstractMapAssert<CookieMapAssert, Map<String, Cookie>, String, Cookie> {
    public CookieMapAssert(Cookie[] actual) {
        super(CookieMapAssert.toMap(actual), CookieMapAssert.class);
        this.as("Cookies", new Object[0]);
    }

    private static Map<String, Cookie> toMap(Cookie[] cookies) {
        LinkedHashMap<String, Cookie> map = new LinkedHashMap<String, Cookie>();
        for (Cookie cookie : cookies) {
            map.putIfAbsent(cookie.getName(), cookie);
        }
        return map;
    }

    public CookieMapAssert containsCookie(String name) {
        return (CookieMapAssert)this.containsKey(name);
    }

    public CookieMapAssert containsCookies(String ... names) {
        return (CookieMapAssert)this.containsKeys(names);
    }

    public CookieMapAssert doesNotContainCookie(String name) {
        return (CookieMapAssert)this.doesNotContainKey(name);
    }

    public CookieMapAssert doesNotContainCookies(String ... names) {
        return (CookieMapAssert)this.doesNotContainKeys(names);
    }

    public CookieMapAssert hasCookieSatisfying(String name, Consumer<Cookie> cookieRequirements) {
        return (CookieMapAssert)this.hasEntrySatisfying(name, cookieRequirements);
    }

    public CookieMapAssert hasValue(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getValue()).isEqualTo(expected));
    }

    public CookieMapAssert hasMaxAge(String name, Duration expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((Duration)Duration.ofSeconds(cookie.getMaxAge())).isEqualTo((Object)expected));
    }

    public CookieMapAssert hasPath(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getPath()).isEqualTo(expected));
    }

    public CookieMapAssert hasDomain(String name, String expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((String)cookie.getDomain()).isEqualTo(expected));
    }

    public CookieMapAssert isSecure(String name, boolean expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((boolean)cookie.getSecure()).isEqualTo(expected));
    }

    public CookieMapAssert isHttpOnly(String name, boolean expected) {
        return this.hasCookieSatisfying(name, cookie -> Assertions.assertThat((boolean)cookie.isHttpOnly()).isEqualTo(expected));
    }
}

