/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class TestClassScanner {
    private static final String SPRING_EXTENSION_NAME = "org.springframework.test.context.junit.jupiter.SpringExtension";
    private static final String EXTEND_WITH_ANNOTATION_NAME = "org.junit.jupiter.api.extension.ExtendWith";
    private static final String CLASS_TEMPLATE_ANNOTATION_NAME = "org.junit.jupiter.api.ClassTemplate";
    private static final String NESTED_ANNOTATION_NAME = "org.junit.jupiter.api.Nested";
    private static final String RUN_WITH_ANNOTATION_NAME = "org.junit.runner.RunWith";
    private static final String SPRING_JUNIT4_CLASS_RUNNER_NAME = "org.springframework.test.context.junit4.SpringJUnit4ClassRunner";
    private static final String SPRING_RUNNER_NAME = "org.springframework.test.context.junit4.SpringRunner";
    private final Log logger = LogFactory.getLog(TestClassScanner.class);
    private final Set<Path> classpathRoots;

    TestClassScanner(Set<Path> classpathRoots) {
        this.classpathRoots = TestClassScanner.assertPreconditions(classpathRoots);
    }

    Stream<Class<?>> scan() {
        return this.scan(new String[0]);
    }

    Stream<Class<?>> scan(String ... packageNames) {
        Assert.noNullElements((Object[])packageNames, (String)"'packageNames' must not contain null elements");
        if (this.logger.isInfoEnabled()) {
            if (packageNames.length > 0) {
                this.logger.info((Object)"Scanning for Spring test classes in packages %s in classpath roots %s".formatted(Arrays.toString(packageNames), this.classpathRoots));
            } else {
                this.logger.info((Object)"Scanning for Spring test classes in all packages in classpath roots %s".formatted(this.classpathRoots));
            }
        }
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        builder.selectors(DiscoverySelectors.selectClasspathRoots(this.classpathRoots));
        if (packageNames.length > 0) {
            builder.filters(new Filter[]{PackageNameFilter.includePackageNames((String[])packageNames)});
        }
        LauncherDiscoveryRequest request = builder.configurationParameter("junit.vintage.discovery.issue.reporting.enabled", "false").build();
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = launcher.discover(request);
        return testPlan.getRoots().stream().map(arg_0 -> ((TestPlan)testPlan).getDescendants(arg_0)).flatMap(Collection::stream).map(TestIdentifier::getSource).flatMap(Optional::stream).filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(this::getJavaClass).flatMap(Optional::stream).filter(this::isSpringTestClass).flatMap(this::expandJupiterClassTemplateIfNecessary).distinct().sorted(Comparator.comparing(Class::getName));
    }

    private Optional<Class<?>> getJavaClass(ClassSource classSource) {
        try {
            return Optional.of(classSource.getJavaClass());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private boolean isSpringTestClass(Class<?> clazz) {
        boolean isSpringTestClass;
        boolean bl = isSpringTestClass = TestClassScanner.isJupiterSpringTestClass(clazz) || TestClassScanner.isJUnit4SpringTestClass(clazz) || TestClassScanner.isGenericSpringTestClass(clazz);
        if (isSpringTestClass && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Found Spring test class: " + clazz.getName()));
        }
        return isSpringTestClass;
    }

    private Stream<Class<?>> expandJupiterClassTemplateIfNecessary(Class<?> testClass) {
        if (TestClassScanner.isJupiterClassTemplate(testClass)) {
            HashSet testClasses = new HashSet();
            TestClassScanner.collectNestedTestClasses(testClass, testClasses, new HashSet());
            testClasses.add(testClass);
            return testClasses.stream();
        }
        return Stream.of(testClass);
    }

    private static void collectNestedTestClasses(Class<?> testClass, Set<Class<?>> testClasses, Set<Class<?>> visited) {
        if (visited.add(testClass)) {
            Class<?> superclass = testClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                TestClassScanner.collectNestedTestClasses(superclass, testClasses, visited);
            }
            for (Class<?> nestedClass : testClass.getDeclaredClasses()) {
                if (!TestClassScanner.isJupiterNestedClass(nestedClass)) continue;
                testClasses.add(nestedClass);
                TestClassScanner.collectNestedTestClasses(nestedClass, testClasses, visited);
            }
        }
    }

    private static boolean isJupiterSpringTestClass(Class<?> clazz) {
        return MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withEnclosingClasses(ClassUtils::isInnerClass).from(clazz).stream(EXTEND_WITH_ANNOTATION_NAME).map(annotation -> annotation.getClassArray("value")).flatMap(Arrays::stream).map(Class::getName).anyMatch(SPRING_EXTENSION_NAME::equals);
    }

    private static boolean isJupiterClassTemplate(Class<?> clazz) {
        return MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(CLASS_TEMPLATE_ANNOTATION_NAME);
    }

    private static boolean isJupiterNestedClass(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers()) && ClassUtils.isInnerClass(clazz) && MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(NESTED_ANNOTATION_NAME);
    }

    private static boolean isJUnit4SpringTestClass(Class<?> clazz) {
        MergedAnnotation mergedAnnotation = MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).get(RUN_WITH_ANNOTATION_NAME);
        if (mergedAnnotation.isPresent()) {
            String name = mergedAnnotation.getClass("value").getName();
            return SPRING_JUNIT4_CLASS_RUNNER_NAME.equals(name) || SPRING_RUNNER_NAME.equals(name);
        }
        return false;
    }

    private static boolean isGenericSpringTestClass(Class<?> clazz) {
        MergedAnnotations mergedAnnotations = MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        return mergedAnnotations.isPresent(ContextConfiguration.class) || mergedAnnotations.isPresent(BootstrapWith.class);
    }

    private static Set<Path> assertPreconditions(Set<Path> classpathRoots) {
        Assert.notEmpty(classpathRoots, (String)"'classpathRoots' must not be null or empty");
        Assert.noNullElements(classpathRoots, (String)"'classpathRoots' must not contain null elements");
        classpathRoots.forEach(classpathRoot -> Assert.isTrue((boolean)Files.exists(classpathRoot, new LinkOption[0]), () -> "Classpath root [%s] does not exist".formatted(classpathRoot)));
        return classpathRoots;
    }
}

