/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.mock.web.MockSessionCookieConfig;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MockServletContext
implements ServletContext {
    private static final String COMMON_DEFAULT_SERVLET_NAME = "default";
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private static final Set<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = CollectionUtils.newLinkedHashSet((int)3);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private final String resourceBasePath;
    private String contextPath = "";
    private final Map<String, ServletContext> contexts = new HashMap<String, ServletContext>();
    private int majorVersion = 6;
    private int minorVersion = 1;
    private int effectiveMajorVersion = 6;
    private int effectiveMinorVersion = 1;
    private final Map<String, RequestDispatcher> namedRequestDispatchers = new HashMap<String, RequestDispatcher>();
    private String defaultServletName = "default";
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String servletContextName = "MockServletContext";
    private final Set<String> declaredRoles = new LinkedHashSet<String>();
    private @Nullable Set<SessionTrackingMode> sessionTrackingModes;
    private final SessionCookieConfig sessionCookieConfig = new MockSessionCookieConfig();
    private int sessionTimeout;
    private @Nullable String requestCharacterEncoding;
    private @Nullable String responseCharacterEncoding;
    private final Map<String, FilterRegistration> filterRegistrations = new LinkedHashMap<String, FilterRegistration>();
    private final Map<String, MediaType> mimeTypes = new LinkedHashMap<String, MediaType>();

    public MockServletContext() {
        this("", null);
    }

    public MockServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockServletContext(@Nullable ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockServletContext(String resourceBasePath, @Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        this.resourceBasePath = resourceBasePath;
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("jakarta.servlet.context.tempdir", new File(tempDir));
        }
        this.registerNamedDispatcher(this.defaultServletName, new MockRequestDispatcher(this.defaultServletName));
    }

    protected String getResourceLocation(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return this.resourceBasePath + (String)path;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void registerContext(String contextPath, ServletContext context) {
        this.contexts.put(contextPath, context);
    }

    public @Nullable ServletContext getContext(String contextPath) {
        if (this.contextPath.equals(contextPath)) {
            return this;
        }
        return this.contexts.get(contextPath);
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setEffectiveMajorVersion(int effectiveMajorVersion) {
        this.effectiveMajorVersion = effectiveMajorVersion;
    }

    public int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    public void setEffectiveMinorVersion(int effectiveMinorVersion) {
        this.effectiveMinorVersion = effectiveMinorVersion;
    }

    public int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    public @Nullable String getMimeType(String filePath) {
        String extension = StringUtils.getFilenameExtension((String)filePath);
        if (this.mimeTypes.containsKey(extension)) {
            return this.mimeTypes.get(extension).toString();
        }
        return MediaTypeFactory.getMediaType((String)filePath).map(MimeType::toString).orElse(null);
    }

    public void addMimeType(String fileExtension, MediaType mimeType) {
        Assert.notNull((Object)fileExtension, (String)"'fileExtension' must not be null");
        this.mimeTypes.put(fileExtension, mimeType);
    }

    public @Nullable Set<String> getResourcePaths(String path) {
        Object actualPath = path.endsWith("/") ? path : path + "/";
        String resourceLocation = this.getResourceLocation((String)actualPath);
        Resource resource = null;
        try {
            resource = this.resourceLoader.getResource(resourceLocation);
            File file = resource.getFile();
            Object[] fileList = file.list();
            if (ObjectUtils.isEmpty((Object[])fileList)) {
                return null;
            }
            LinkedHashSet resourcePaths = CollectionUtils.newLinkedHashSet((int)fileList.length);
            for (Object fileEntry : fileList) {
                String resultPath = (String)actualPath + (String)fileEntry;
                if (resource.createRelative((String)fileEntry).getFile().isDirectory()) {
                    resultPath = resultPath + "/";
                }
                resourcePaths.add(resultPath);
            }
            return resourcePaths;
        }
        catch (IOException | InvalidPathException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not get resource paths for " + String.valueOf(resource != null ? resource : resourceLocation)), (Throwable)ex);
            }
            return null;
        }
    }

    public @Nullable URL getResource(String path) throws MalformedURLException {
        String resourceLocation = this.getResourceLocation(path);
        Resource resource = null;
        try {
            resource = this.resourceLoader.getResource(resourceLocation);
            if (!resource.exists()) {
                return null;
            }
            return resource.getURL();
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException | InvalidPathException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not get URL for resource " + String.valueOf(resource != null ? resource : resourceLocation)), (Throwable)ex);
            }
            return null;
        }
    }

    public @Nullable InputStream getResourceAsStream(String path) {
        String resourceLocation = this.getResourceLocation(path);
        Resource resource = null;
        try {
            resource = this.resourceLoader.getResource(resourceLocation);
            if (!resource.exists()) {
                return null;
            }
            return resource.getInputStream();
        }
        catch (IOException | InvalidPathException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not open InputStream for resource " + String.valueOf(resource != null ? resource : resourceLocation)), (Throwable)ex);
            }
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        Assert.isTrue((boolean)path.startsWith("/"), () -> "RequestDispatcher path [" + path + "] at ServletContext level must start with '/'");
        return new MockRequestDispatcher(path);
    }

    public @Nullable RequestDispatcher getNamedDispatcher(String path) {
        return this.namedRequestDispatchers.get(path);
    }

    public void registerNamedDispatcher(String name, RequestDispatcher requestDispatcher) {
        Assert.notNull((Object)name, (String)"RequestDispatcher name must not be null");
        Assert.notNull((Object)requestDispatcher, (String)"RequestDispatcher must not be null");
        this.namedRequestDispatchers.put(name, requestDispatcher);
    }

    public void unregisterNamedDispatcher(String name) {
        Assert.notNull((Object)name, (String)"RequestDispatcher name must not be null");
        this.namedRequestDispatchers.remove(name);
    }

    public String getDefaultServletName() {
        return this.defaultServletName;
    }

    public void setDefaultServletName(String defaultServletName) {
        Assert.hasText((String)defaultServletName, (String)"defaultServletName must not be null or empty");
        this.unregisterNamedDispatcher(this.defaultServletName);
        this.defaultServletName = defaultServletName;
        this.registerNamedDispatcher(this.defaultServletName, new MockRequestDispatcher(this.defaultServletName));
    }

    public void log(String message) {
        this.logger.info((Object)message);
    }

    public void log(String message, Throwable ex) {
        this.logger.info((Object)message, ex);
    }

    public @Nullable String getRealPath(String path) {
        String resourceLocation = this.getResourceLocation(path);
        Resource resource = null;
        try {
            resource = this.resourceLoader.getResource(resourceLocation);
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException | InvalidPathException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not determine real path of resource " + String.valueOf(resource != null ? resource : resourceLocation)), (Throwable)ex);
            }
            return null;
        }
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public @Nullable String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        if (this.initParameters.containsKey(name)) {
            return false;
        }
        this.initParameters.put(name, value);
        return true;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    public @Nullable Object getAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    public void setAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.attributes.remove(name);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public @Nullable ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        Assert.notNull((Object)roleNames, (String)"Role names array must not be null");
        for (String roleName : roleNames) {
            Assert.hasLength((String)roleName, (String)"Role name must not be empty");
            this.declaredRoles.add(roleName);
        }
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) throws IllegalStateException, IllegalArgumentException {
        this.sessionTrackingModes = sessionTrackingModes;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.sessionTrackingModes != null ? Collections.unmodifiableSet(this.sessionTrackingModes) : DEFAULT_SESSION_TRACKING_MODES;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setRequestCharacterEncoding(@Nullable String requestCharacterEncoding) {
        this.requestCharacterEncoding = requestCharacterEncoding;
    }

    public @Nullable String getRequestCharacterEncoding() {
        return this.requestCharacterEncoding;
    }

    public void setResponseCharacterEncoding(@Nullable String responseCharacterEncoding) {
        this.responseCharacterEncoding = responseCharacterEncoding;
    }

    public @Nullable String getResponseCharacterEncoding() {
        return this.responseCharacterEncoding;
    }

    public void addFilterRegistration(FilterRegistration registration) {
        this.filterRegistrations.put(registration.getName(), registration);
    }

    public @Nullable FilterRegistration getFilterRegistration(String filterName) {
        return this.filterRegistrations.get(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return Collections.unmodifiableMap(this.filterRegistrations);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public @Nullable ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return Collections.emptyMap();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException();
    }

    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException();
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException();
    }

    static {
        DEFAULT_SESSION_TRACKING_MODES.add(SessionTrackingMode.COOKIE);
        DEFAULT_SESSION_TRACKING_MODES.add(SessionTrackingMode.URL);
        DEFAULT_SESSION_TRACKING_MODES.add(SessionTrackingMode.SSL);
    }
}

