/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import jakarta.servlet.http.Cookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class MockMvcClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final MockMvc mockMvc;

    MockMvcClientHttpRequestFactory(MockMvc mockMvc) {
        Assert.notNull((Object)mockMvc, (String)"MockMvc must not be null");
        this.mockMvc = mockMvc;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new MockMvcClientHttpRequest(httpMethod, uri);
    }

    private class MockMvcClientHttpRequest
    extends MockClientHttpRequest {
        MockMvcClientHttpRequest(HttpMethod httpMethod, URI uri) {
            super(httpMethod, uri);
        }

        @Override
        public ClientHttpResponse executeInternal() {
            try {
                MockHttpServletRequestBuilder servletRequestBuilder = (MockHttpServletRequestBuilder)((MockHttpServletRequestBuilder)MockMvcRequestBuilders.request(this.getMethod(), this.getURI()).headers(this.getHeaders())).content(this.getBodyAsBytes());
                this.addCookies(servletRequestBuilder);
                MockHttpServletResponse servletResponse = MockMvcClientHttpRequestFactory.this.mockMvc.perform(servletRequestBuilder).andReturn().getResponse();
                MockClientHttpResponse clientResponse = new MockClientHttpResponse(MockMvcClientHttpRequest.getResponseBody(servletResponse), HttpStatusCode.valueOf((int)servletResponse.getStatus()));
                MockMvcClientHttpRequest.copyHeaders(servletResponse, clientResponse);
                return clientResponse;
            }
            catch (Exception ex) {
                byte[] body2 = ex.toString().getBytes(StandardCharsets.UTF_8);
                return new MockClientHttpResponse(body2, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        private void addCookies(MockHttpServletRequestBuilder requestBuilder) {
            List values = this.getHeaders().get("Cookie");
            if (!ObjectUtils.isEmpty((Object)values)) {
                Stream<Cookie> stream = values.stream().flatMap(header -> StringUtils.commaDelimitedListToSet((String)header).stream()).map(value -> {
                    String[] parts = StringUtils.split((String)value, (String)"=");
                    Assert.isTrue((parts != null && parts.length == 2 ? 1 : 0) != 0, (String)("Invalid cookie: '" + value + "'"));
                    return new Cookie(parts[0], parts[1]);
                });
                MockHttpServletRequestBuilder mockHttpServletRequestBuilder = requestBuilder;
                Objects.requireNonNull(mockHttpServletRequestBuilder);
                MockHttpServletRequestBuilder mockHttpServletRequestBuilder2 = mockHttpServletRequestBuilder;
                stream.forEach(xva$0 -> mockHttpServletRequestBuilder2.cookie((Cookie)xva$0));
            }
        }

        private static byte[] getResponseBody(MockHttpServletResponse servletResponse) {
            String error;
            byte[] body2 = servletResponse.getContentAsByteArray();
            if (body2.length == 0 && StringUtils.hasLength((String)(error = servletResponse.getErrorMessage()))) {
                body2 = error.getBytes(StandardCharsets.UTF_8);
            }
            return body2;
        }

        private static void copyHeaders(MockHttpServletResponse servletResponse, MockClientHttpResponse clientResponse) {
            servletResponse.getHeaderNames().forEach(name -> servletResponse.getHeaders((String)name).forEach(value -> clientResponse.getHeaders().add(name, value)));
        }
    }
}

