/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import org.jspecify.annotations.Nullable;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.test.context.transaction.TransactionContext;

final class TransactionContextHolder {
    private static final ThreadLocal<TransactionContext> currentTransactionContext = new NamedInheritableThreadLocal("Test Transaction Context");

    private TransactionContextHolder() {
    }

    static void setCurrentTransactionContext(TransactionContext transactionContext) {
        currentTransactionContext.set(transactionContext);
    }

    static @Nullable TransactionContext getCurrentTransactionContext() {
        return currentTransactionContext.get();
    }

    static @Nullable TransactionContext removeCurrentTransactionContext() {
        TransactionContext transactionContext = currentTransactionContext.get();
        currentTransactionContext.remove();
        return transactionContext;
    }
}

