/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MockMvcBuilder;
import org.springframework.test.web.servlet.client.CookieAssertions;
import org.springframework.test.web.servlet.client.DefaultRestTestClientBuilder;
import org.springframework.test.web.servlet.client.EntityExchangeResult;
import org.springframework.test.web.servlet.client.HeaderAssertions;
import org.springframework.test.web.servlet.client.JsonPathAssertions;
import org.springframework.test.web.servlet.client.MockMvcClientHttpRequestFactory;
import org.springframework.test.web.servlet.client.StatusAssertions;
import org.springframework.test.web.servlet.client.XpathAssertions;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.RouterFunctionMockMvcBuilder;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.client.RestClient;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

public interface RestTestClient {
    public static final String RESTTESTCLIENT_REQUEST_ID = "RestTestClient-Request-Id";

    public RequestHeadersUriSpec<?> get();

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestHeadersUriSpec<?> delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public <B extends Builder<B>> Builder<B> mutate();

    public static StandaloneSetupBuilder bindToController(Object ... controllers) {
        return new DefaultRestTestClientBuilder.DefaultStandaloneSetupBuilder(controllers);
    }

    public static RouterFunctionSetupBuilder bindToRouterFunction(RouterFunction<?> ... routerFunctions) {
        return new DefaultRestTestClientBuilder.DefaultRouterFunctionSetupBuilder(routerFunctions);
    }

    public static WebAppContextSetupBuilder bindToApplicationContext(WebApplicationContext context) {
        return new DefaultRestTestClientBuilder.DefaultWebAppContextSetupBuilder(context);
    }

    public static Builder<?> bindTo(MockMvc mockMvc) {
        MockMvcClientHttpRequestFactory requestFactory = new MockMvcClientHttpRequestFactory(mockMvc);
        return RestTestClient.bindToServer(requestFactory);
    }

    public static Builder<?> bindToServer() {
        return new DefaultRestTestClientBuilder();
    }

    public static Builder<?> bindToServer(ClientHttpRequestFactory requestFactory) {
        return new DefaultRestTestClientBuilder(RestClient.builder().requestFactory(requestFactory));
    }

    public static interface Builder<B extends Builder<B>> {
        public <T extends B> T baseUrl(String var1);

        public <T extends B> T uriBuilderFactory(UriBuilderFactory var1);

        public <T extends B> T defaultHeader(String var1, String ... var2);

        public <T extends B> T defaultHeaders(Consumer<HttpHeaders> var1);

        public <T extends B> T defaultCookie(String var1, String ... var2);

        public <T extends B> T defaultCookies(Consumer<MultiValueMap<String, String>> var1);

        public <T extends B> T defaultApiVersion(Object var1);

        public <T extends B> T apiVersionInserter(@Nullable ApiVersionInserter var1);

        public <T extends B> T requestInterceptor(ClientHttpRequestInterceptor var1);

        public <T extends B> T requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> var1);

        public <T extends B> T configureMessageConverters(Consumer<HttpMessageConverters.ClientBuilder> var1);

        public <T extends B> T entityExchangeResultConsumer(Consumer<EntityExchangeResult<?>> var1);

        public RestTestClient build();
    }

    public static interface BodyContentSpec {
        public EntityExchangeResult<Void> isEmpty();

        default public BodyContentSpec json(String expectedJson) {
            return this.json(expectedJson, JsonCompareMode.LENIENT);
        }

        public BodyContentSpec json(String var1, JsonCompareMode var2);

        public BodyContentSpec json(String var1, JsonComparator var2);

        public BodyContentSpec xml(String var1);

        public JsonPathAssertions jsonPath(String var1);

        default public XpathAssertions xpath(String expression, Object ... args) {
            return this.xpath(expression, null, args);
        }

        public XpathAssertions xpath(String var1, @Nullable Map<String, String> var2, Object ... var3);

        public BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> var1);

        public EntityExchangeResult<byte[]> returnResult();
    }

    public static interface BodySpec<B, S extends BodySpec<B, S>> {
        public <T extends S> T isEqualTo(@Nullable B var1);

        public <T extends S> T value(Matcher<? super @Nullable B> var1);

        public <T extends S, R> T value(Function<@Nullable B, @Nullable R> var1, Matcher<? super @Nullable R> var2);

        public <T extends S> T value(Consumer<@Nullable B> var1);

        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> var1);

        public EntityExchangeResult<B> returnResult();
    }

    public static interface ResponseSpec {
        public ResponseSpec expectAll(ResponseSpecConsumer ... var1);

        public StatusAssertions expectStatus();

        public HeaderAssertions expectHeader();

        public CookieAssertions expectCookie();

        public <B> BodySpec<B, ?> expectBody(Class<B> var1);

        public <B> BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> var1);

        public BodyContentSpec expectBody();

        public <T> EntityExchangeResult<T> returnResult(Class<T> var1);

        public <T> EntityExchangeResult<T> returnResult(ParameterizedTypeReference<T> var1);

        @FunctionalInterface
        public static interface ResponseSpecConsumer
        extends Consumer<ResponseSpec> {
        }
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestHeadersSpec<?> body(Object var1);
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S cookie(String var1, String var2);

        public S cookies(Consumer<MultiValueMap<String, String>> var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S apiVersion(@Nullable Object var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public ResponseSpec exchange();

        public ResponseSpec exchangeSuccessfully();
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ? extends @Nullable Object> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }

    public static interface WebAppContextSetupBuilder
    extends MockMvcSetupBuilder<WebAppContextSetupBuilder, DefaultMockMvcBuilder> {
    }

    public static interface RouterFunctionSetupBuilder
    extends MockMvcSetupBuilder<RouterFunctionSetupBuilder, RouterFunctionMockMvcBuilder> {
    }

    public static interface StandaloneSetupBuilder
    extends MockMvcSetupBuilder<StandaloneSetupBuilder, StandaloneMockMvcBuilder> {
    }

    public static interface MockMvcSetupBuilder<S extends Builder<S>, M extends MockMvcBuilder>
    extends Builder<S> {
        public <T extends S> T configureServer(Consumer<M> var1);
    }
}

