/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated(since="7.0")
public abstract class ProfileValueUtils {
    private static final Log logger = LogFactory.getLog(ProfileValueUtils.class);

    public static ProfileValueSource retrieveProfileValueSource(Class<?> testClass) {
        ProfileValueSource profileValueSource;
        Class profileValueSourceType;
        Assert.notNull(testClass, (String)"testClass must not be null");
        Class<ProfileValueSourceConfiguration> annotationType = ProfileValueSourceConfiguration.class;
        ProfileValueSourceConfiguration config = (ProfileValueSourceConfiguration)AnnotatedElementUtils.findMergedAnnotation(testClass, annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved @ProfileValueSourceConfiguration [" + String.valueOf(config) + "] for test class [" + testClass.getName() + "]"));
        }
        if (config != null) {
            profileValueSourceType = config.value();
        } else {
            profileValueSourceType = (Class)AnnotationUtils.getDefaultValue(annotationType);
            Assert.state((profileValueSourceType != null ? 1 : 0) != 0, (String)"No default ProfileValueSource class");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved ProfileValueSource type [" + String.valueOf(profileValueSourceType) + "] for class [" + testClass.getName() + "]"));
        }
        if (SystemProfileValueSource.class == profileValueSourceType) {
            profileValueSource = SystemProfileValueSource.getInstance();
        } else {
            try {
                profileValueSource = (ProfileValueSource)ReflectionUtils.accessibleConstructor((Class)profileValueSourceType, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not instantiate a ProfileValueSource of type [" + String.valueOf(profileValueSourceType) + "] for class [" + testClass.getName() + "]: using default."), (Throwable)ex);
                }
                profileValueSource = SystemProfileValueSource.getInstance();
            }
        }
        return profileValueSource;
    }

    public static boolean isTestEnabledInThisEnvironment(Class<?> testClass) {
        IfProfileValue ifProfileValue = (IfProfileValue)AnnotatedElementUtils.findMergedAnnotation(testClass, IfProfileValue.class);
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), ifProfileValue);
    }

    public static boolean isTestEnabledInThisEnvironment(Method testMethod, Class<?> testClass) {
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), testMethod, testClass);
    }

    public static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, Method testMethod, Class<?> testClass) {
        IfProfileValue ifProfileValue = (IfProfileValue)AnnotatedElementUtils.findMergedAnnotation(testClass, IfProfileValue.class);
        boolean classLevelEnabled = ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        if (classLevelEnabled) {
            ifProfileValue = (IfProfileValue)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)testMethod, IfProfileValue.class);
            return ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        }
        return false;
    }

    private static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, @Nullable IfProfileValue ifProfileValue) {
        if (ifProfileValue == null) {
            return true;
        }
        String environmentValue = profileValueSource.get(ifProfileValue.name());
        String[] annotatedValues = ifProfileValue.values();
        if (StringUtils.hasLength((String)ifProfileValue.value())) {
            Assert.isTrue((annotatedValues.length == 0 ? 1 : 0) != 0, (String)"Setting both the 'value' and 'values' attributes of @IfProfileValue is not allowed: choose one or the other.");
            annotatedValues = new String[]{ifProfileValue.value()};
        }
        for (String value : annotatedValues) {
            if (!ObjectUtils.nullSafeEquals((Object)value, (Object)environmentValue)) continue;
            return true;
        }
        return false;
    }
}

